/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.filters;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import oracle.cloud.storage.nls.ClientMessage;

public final class HeaderOnlyLogger
extends ClientFilter {
    private static final Logger LOGGER = Logger.getLogger(HeaderOnlyLogger.class.getName());
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = "> ";
    private static final String RESPONSE_PREFIX = "< ";
    private final Logger logger;
    private long _id = 0L;

    public HeaderOnlyLogger() {
        this(LOGGER);
    }

    public HeaderOnlyLogger(Logger logger) {
        this.logger = logger;
    }

    private void log(StringBuilder b) {
        this.logger.info(b.toString());
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(Long.toString(id)).append(" ");
        return b;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        long id = ++this._id;
        this.logRequest(id, request);
        ClientResponse response = this.getNext().handle(request);
        this.logResponse(id, response);
        return response;
    }

    private void logRequest(long id, ClientRequest request) {
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, id, request);
        this.printRequestHeaders(b, id, (MultivaluedMap<String, Object>)request.getHeaders());
        this.log(b);
    }

    private void printRequestLine(StringBuilder b, long id, ClientRequest request) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(ClientMessage.outboundRequest()).append("\n");
        this.prefixId(b, id).append(REQUEST_PREFIX).append(request.getMethod()).append(" ").append(request.getURI().toASCIIString()).append("\n");
    }

    private void printRequestHeaders(StringBuilder b, long id, MultivaluedMap<String, Object> headers) {
        for (Map.Entry e : headers.entrySet()) {
            List val = (List)e.getValue();
            String header = (String)e.getKey();
            if (val.size() == 1) {
                this.prefixId(b, id).append(REQUEST_PREFIX).append(header).append(": ").append(ClientRequest.getHeaderValue(val.get(0))).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (Object o : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append(ClientRequest.getHeaderValue(o));
            }
            this.prefixId(b, id).append(REQUEST_PREFIX).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }

    private void logResponse(long id, ClientResponse response) {
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, id, response);
        this.printResponseHeaders(b, id, (MultivaluedMap<String, String>)response.getHeaders());
        this.log(b);
    }

    private void printResponseLine(StringBuilder b, long id, ClientResponse response) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(ClientMessage.inboundResponse()).append("\n");
        this.prefixId(b, id).append(RESPONSE_PREFIX).append(Integer.toString(response.getStatus())).append("\n");
    }

    private void printResponseHeaders(StringBuilder b, long id, MultivaluedMap<String, String> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                this.prefixId(b, id).append(RESPONSE_PREFIX).append(header).append(": ").append(value).append("\n");
            }
        }
        this.prefixId(b, id).append(RESPONSE_PREFIX).append("\n");
    }
}

