/**
 * select2
 * class=sel2selを付けたプルダウンに対して絞り込みを行う機能を追加します。
 * classの付加とJS読み込みで自動的に動作します。
 * 「*」をクリックでテキストボックスを表示/削除します。
 * option数が非常に多い倍は処理時間がかかるかもしれません。
 * 
 * jQuery1.4の機能で作成しています。
 * 
 */

this.select2 = function(){	
	var xOffset = 30;
	var yOffset = -60;

	// 絞り込み動作
	var sel2sel = function(_tgtid,_txt){
		// IEに対応しなくて良い場合はcssでコントロール可能で、こちらの方が高速(適当)
	/*
		$("#"+_tgtid+" option").each(function(i){
			if(_txt == ""){$(this).css("display","inline");}
			else{
				if( $(this).text().indexOf(_txt)>=0 ){
					$(this).css("display","inline");
				}
				else{
					$(this).css("display","none");
				}
			}
		});
	*/
	
		// IEに対応させる場合は保存したorgoptionを走査してから置き換え
		// この場合はselectedを取得してから戻してやる必要がある
		var _orgoptions = document.getElementById(_tgtid).orgoptions;
		var _tgtjq = $("#"+_tgtid);
		var _selected = _tgtjq.val();
		var _newoptions = new Array();
		for( i=0; i<_orgoptions.length; i++ ){
			if (_txt == ""){ // 元に戻す(すべて追加)
				_newoptions.push($(_orgoptions[i]).attr('outerHTML'));
			}
			else if( _orgoptions[i].tagName == "OPTGROUP" ){ // optionGroupの場合内部のOptionを走査する必要あり
				// optionGroupは入れ子にはならないはず。面倒なので関数を分けずにここでやってしまう。
				var _groupChildren = $(_orgoptions[i]).children();
				var _grpFlg = false;
				var _allAttache = false;
				if( _orgoptions[i].label.indexOf(_txt)>=0 ){ _allAttache = true; }
				var _thisGroup = null;
				if( !_groupChildren ){ continue; }
				for( j=0; j<_groupChildren.length; j++ ){
					if( _groupChildren[j].innerText.indexOf(_txt)>=0 || _allAttache){
						if( ! _grpFlg ){ 
							// グループを維持するため、手動でグループを作成する(とりあえずラベルだけ)
							_grpFlg = true;
							_thisGroup = $("<optgroup> </optgroup>").attr("label",_orgoptions[i].label);
						}
						if( $(_groupChildren[j]).attr('disabled') ){ continue; }
						_thisGroup.append($(_groupChildren[j]).attr('outerHTML'));
					}
				}
				if( _grpFlg ){ _newoptions.push($(_thisGroup).attr('outerHTML'));  }
			}
			else if( _orgoptions[i].innerText.indexOf(_txt)>=0){ // 合致したもの
				if( $(_orgoptions[i]).attr('disabled') ){ continue; }
				_newoptions.push($(_orgoptions[i]).attr('outerHTML'));
			}
		}
		$("#"+_tgtid).children().remove();
		_tgtjq.append(_newoptions.join(" ")).val(_selected); // 選択を戻す
		if( _tgtjq.val() == null ){ _tgtjq.attr("selectedIndex", 0); } // nullの場合は先頭選択
		// IE対応ここまで
		
	}

	var sel2inputDel = function(_tgt){
		setTimeout(function() {
			sel2sel(_tgt,"");
			$(document.getElementById(_tgt+"sel2outer")).remove(); 
		}, 100);
	}
	
	// オプション保存、*の追加
	var sel2create = function(_this){
		var thisoptions = $(_this).children();
		_this.orgoptions = thisoptions.clone();
		$(_this).after("<span class='select2' targetId='"+_this.id+"'>*</span>");
		//$(_this).change( function(){sel2inputDel(_this.id)} );
		$(_this).width($(_this).width());
	}
	select2.sel2create = sel2create; // 外部からCallできるようにプロパティに設定しておく
	
	// *追加の実行	大量にやると重くなるので最大12個までしか処理しない
	var eachCount=0;
	$(".sel2sel").each(function(i){
		if( eachCount < 12 ){
			sel2create(this);
			eachCount++;
		}
	});

	// inputタグ表示/削除イベント
	$(".select2").live("click", function(e){
		var tgtId = this.getAttribute("targetId");
		var thisId = tgtId + "sel2";
		var outerId = tgtId + "sel2outer";
		if( document.getElementById(thisId) ){ // 削除
			sel2inputDel(tgtId)
		}
		else{ // 表示
			$("body").append("<div id='"+outerId+"' style='position:absolute;background-color:silver;'> <input size='7' name='dummy' id='"+thisId+"' class='sel2input' targetId='"+tgtId
				+"' /><span class='select2' style='cursor:default' targetId='"+tgtId+"'>×</span></div>");
			$("#"+outerId)
			.css("top",(e.pageY - xOffset) + "px")
			.css("left",(e.pageX + yOffset) + "px")
			.children("input")[0].focus();
		}
	 });

	// 絞り込みイベント
	 $(".sel2input").live("change", function(e){ // 本来はkeyupにしたいがIE7モードで遅いのでchangeにする
		var tgtId = this.getAttribute("targetId");
		sel2sel(tgtId,this.value);
	 }).live("keyup", function(e){
	 	if(e.keyCode == 13){
	 		var tgtId = this.getAttribute("targetId");
	 		$(this).change();
	 		$("#"+tgtId).focus();
	 	}
	 });
	 
	 /*
	 //動的追加処理に対応する方法の例(IEは11のみ対応なので、IE7モードの場合は利用できない)
	 function mo_callback(mutations){ 
		mutations.forEach( mutation => { // 個別の（動的な）要素変更情報
			mutation.addedNodes.forEach( node => { // 追加された要素（ノードリスト）
				if( node.tagName==='SELECT' && $(node).hasClass('sel2sel') ) { //変更ノードを指定
	          			sel2create(node);
				}
			});
		});
	}
	var options = {childList: true, subtree:true};
	var mo = new MutationObserver(mo_callback);
	mo.observe(document, options); // 特定の親を指定しずらいので、負荷がかかるのを承知でdocumentの子孫ノード全てを指定
	//動的追加対応ここまで
	*/
}

// 自動実行
$(document).ready(function(){
	select2();
});

