<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0004"
	title    = "コード"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,CLM,CODE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" scope="{@scope}">
	select
		'1' as WRITABLE,A.CLM,C.NAME_JA,B.LNAME,B.SNAME,A.CODE,A.SEQNO
		,A.CODELVL,A.CODEGRP,A.CODE_PARAM,A.COMMENTS,B.DESCRIPTION,A.SYSTEM_ID,A.KBSAKU,A.SUBSYS
		,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ
		,'0' EXIST_GEA08,0 UNIQ_GEA08,A.CLM CLM_T,A.CLM ||'.'|| A.CODE as CODE_T
	from GEA04 A left outer join GEA08 B
			on	A.SYSTEM_ID	= B.SYSTEM_ID
			and	B.CLM		= A.CLM ||'.'|| A.CODE
			and	A.KBSAKU	= B.KBSAKU
			and	A.FGJ		= B.FGJ
			and	B.LANG		= 'ja'
				left outer join GEA08 C
							on	A.SYSTEM_ID	= C.SYSTEM_ID
							and	A.CLM		= C.CLM
							and	A.KBSAKU	= C.KBSAKU
							and	A.FGJ		= C.FGJ
							and	C.LANG		= 'ja'
	where A.SYSTEM_ID IN ( '{@SYSTEM_ID}','{@REP.BASE , ','}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "UPPER(A.CLM)	like UPPER('{@CLM}')"	/>
		<og:and value = "UPPER(A.CODE)	like UPPER('{@CODE}')"	/>
		<og:and value = "A.KBSAKU		=	'{@KBSAKU}'"		/>
		<og:and value = "A.SUBSYS		like '{@SUBSYS}'"		/>
		<og:and value = "A.CODEGRP		like '{@CODEGRP}'"		/>
		<og:and value = "A.CDKH {@CDKH}"						/>
		<og:and value = "C.NAME_JA		like '{@NAME_JA}'"		/>
		<og:and value = "B.LNAME		like '{@LNAME}'"		/>
		<og:and value = "B.SNAME		like '{@SNAME}'"		/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,A.SYSTEM_ID DESC,A.SEQNO" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,CLM,CODE,SEQNO" must="true" />

<og:columnEditor column="DESCRIPTION" clazz="W100" />

<!-- tableFilter でLNAME,SNAME,DESCRIPTION をラベル設定します。キーを CODE_T から取得します。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,LANG,CLM,LRAW,SRAW,DISC" vals="{@SYSTEM_ID},ja,CODE_T,LNAME,SNAME,DESCRIPTION" />

<!-- tableFilter でLNAME,SNAME,DESCRIPTION をラベル設定します。キーを CLM_T から取得します。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,LANG,CLM,LBL" vals="{@SYSTEM_ID},ja,CLM_T,NAME_JA" />

<!-- 7.2.8.0 (2020/09/04) RESOURCE_BASE_SYSTEM_ID 対応 -->
<og:viewMarker command="{@command}">
	<og:columnMarker columns="CLM,NAME_JA,SYSTEM_ID,KBSAKU" onMark="[SYSTEM_ID]" markList="{@BASE}|{@AST}">
		<div style="background-color:#c1ffff;">[$1]</div>
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<!-- GE0003:カラム -->
	<og:link column="CLM" gamenId="GE0003" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="1"
		keys="command,SYSTEM_ID,BASE,AST,CLM,FGJ,KBSAKU"
		vals="NEW,{@SYSTEM_ID},{@BASE},{@AST},[CLM],1,[KBSAKU]" />
	<!-- GE0005:ラベル -->
	<og:link column="LNAME" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="1"
		keys="command,SYSTEM_ID,BASE,AST,CLM,FGJ,LANG,KBSAKU"
		vals="NEW,{@SYSTEM_ID},{@BASE},{@AST},[CLM],1,ja,[KBSAKU]" />
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:equals val1="{@ACTION}" isNull="true">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="NAME_JA" />
		<og:equals val1="{@BASE}{@AST}" isNull="true" >
			<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,CLM,CODE,NAME_JA,KBSAKU,CDKH,FGJ" />
			<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true"	 />
			<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"		 />
		</og:equals>

		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA04" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  action="COPY" noWritable="NAME_JA" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true"  />
		</fieldset>
	</og:equals>
	<og:equals val1="{@ACTION}" val2="MINUS">
		<og:submit  action="COPY"    noWritable="NAME_JA" />
	</og:equals>
	<og:equals val1="{@ACTION}" val2="DIFFERENCE">
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,CLM,CODE,NAME_JA,KBSAKU,CDKH"  />
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" notNull="true">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}" mainTrans="false">
		{@USER.LASTSQL}
	</og:query>

	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,CODE,KBSAKU"
		diffKeys      = "SEQNO,CODELVL,CODEGRP,CODE_PARAM"
		slaveScope    = "request"
		modifyClms    = "UNIQ,UNIQ_GEA08"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,EXIST_GEA08,UNIQ_GEA08,CLM_T,CODE_T"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
