<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0005"
	title    = "ラベル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	2012/07/10 S.Li 概要説明にリンク追加
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" scope="{@scope}">
	select
		'1' as WRITABLE,A.CLM,A.NAME_JA,A.LNAME,A.SNAME,A.DESCRIPTION,A.COMMENTS,A.LANG,A.KBLBL,A.FGLOAD,
		A.SYSTEM_ID,A.KBSAKU,A.SUBSYS,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ
	from GEA08 A
	where A.SYSTEM_ID IN ( '{@SYSTEM_ID}','{@REP.BASE , ','}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "A.LANG			=		'{@LANG}'"			/>
		<og:and value = "UPPER(CLM)		like	UPPER('{@CLM}')"	/>
		<og:and value = "A.NAME_JA		like	'{@NAME_JA}'"		/>
		<og:and value = "A.LNAME		like	'{@LNAME}'"			/>
		<og:and value = "A.SNAME		like	'{@SNAME}'"			/>
		<og:and value = "A.DESCRIPTION	like	'{@DESCRIPTION}'"	/>
		<og:and value = "A.COMMENTS		like	'{@COMMENTS}'"		/>
		<og:and value = "A.KBSAKU		=		'{@KBSAKU}'"		/>
		<og:and value = "A.SUBSYS		like	'{@SUBSYS}'"		/>
		<og:and value = "A.KBLBL		=		'{@KBLBL}'"			/>
		<og:and value = "A.FGLOAD		=		'{@FGLOAD}'"		/>
		<og:and value = "( A.CLM = A.NAME_JA {@NAME_MI} A.NAME_JA is null )" />
		<og:and value = "A.CDKH {@CDKH}" />
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,A.SYSTEM_ID DESC,A.KBSAKU DESC,A.LANG" />
</og:query>

<!-- <og:columnEditor column="DESCRIPTION" editor="TEXTAREA" param="8,100"/> -->
<og:columnEditor columns="DESCRIPTION" renderer="SLABEL" param="50" />
<og:columnEditor columns="NAME_JA,LNAME,DESCRIPTION" clazz="W100" />
<og:columnEditor columns="SYSTEM_ID,CLM" must="true" />

<!-- 7.2.8.0 (2020/09/04) RESOURCE_BASE_SYSTEM_ID 対応 -->
<og:viewMarker command="{@command}">
	<og:columnMarker columns="CLM,NAME_JA,SYSTEM_ID,KBSAKU" onMark="[SYSTEM_ID]" markList="{@BASE}|{@AST}">
		<div style="background-color:#c1ffff;">[$1]</div>
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0003" href="index.jsp" target="CONTENTS" onLink="[KBLBL]" markList="1"
		keys="command,SYSTEM_ID,BASE,AST,CLM,FGJ,LANG,KBSAKU"
		vals="NEW,{@SYSTEM_ID},{@BASE},{@AST},[CLM],1,[LANG],[KBSAKU]" />
	<og:link column="DESCRIPTION" gamenId="GE0006" href="index.jsp" target="CONTENTS" onLink="[SYSTEM_ID]" markList="{@SYSTEM_ID}"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG,KBSAKU"
		vals="NEW,{@SYSTEM_ID},[CLM],1,[LANG],[KBSAKU]" >
			<img src="{@SYS.JSP_IMG}/link.gif" alt="Link" />[DESCRIPTION]
	</og:link>
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:equals val1="{@ACTION}" isNull="true">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:equals val1="{@BASE}{@AST}" isNull="true" >
			<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,CLM,KBSAKU,FGJ"					 />
			<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true"	 />
			<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"		 />
		</og:equals>

		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA04" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  action="COPY" noWritable="null" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true"  />
		</fieldset>
	</og:equals>
	<og:equals val1="{@ACTION}" val2="MINUS">
		<og:submit  action="COPY"    noWritable="null" />
	</og:equals>
	<og:equals val1="{@ACTION}" val2="DIFFERENCE">
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,CLM,KBSAKU"  />
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" notNull="true">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}" mainTrans="false">
		{@USER.LASTSQL}
	</og:query>
	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,LANG,KBSAKU"
		diffKeys      = "NAME_JA,LNAME,SNAME,DESCRIPTION"
		slaveScope    = "request"
		modifyClms    = "UNIQ"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
