/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.Selection_NULL;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class Selection_DBRADIO
extends Selection_NULL {
    private final long DB_CACHE_TIME = HybsSystem.sysInt("DB_CACHE_TIME");
    private final boolean isClass;
    private final boolean isDisable;
    private final long createTime;
    private final Map<String, Integer> adrsMap;
    private final String[] label;
    private final String[] cls;
    private final String[] disabled;
    private static final int VAL = 0;
    private static final int LBL = 1;
    private static final int CLS = 2;
    private static final int DISABLED = 3;
    private static final ApplicationInfo APP_INFO;

    public Selection_DBRADIO(String string, String string2, String string3) {
        String[][] stringArray = DBUtil.dbExecute((String)string, null, (ApplicationInfo)APP_INFO, (String)string2);
        int n = stringArray.length;
        this.label = new String[n];
        this.cls = new String[n];
        this.disabled = new String[n];
        this.adrsMap = Collections.synchronizedMap(new LinkedHashMap(n));
        int n2 = n > 0 ? stringArray[0].length : 0;
        this.isClass = n2 > 2;
        this.isDisable = n2 > 3;
        boolean bl = false;
        ResourceManager resourceManager = null;
        if (n2 == 1) {
            bl = true;
            resourceManager = ResourceFactory.newInstance(string3);
        }
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray[i][0];
            this.label[i] = bl ? resourceManager.getShortLabel(string4) : stringArray[i][1];
            if (this.isClass) {
                this.cls[i] = stringArray[i][2];
            }
            if (this.isDisable) {
                this.disabled[i] = stringArray[i][3];
            }
            this.adrsMap.put(string4, i);
        }
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public String getOption(String string, String string2, boolean bl) {
        String string3 = "<input type=\"radio\" name=\"" + string + "\" value=\"";
        StringBuilder stringBuilder = new StringBuilder(500);
        for (Map.Entry<String, Integer> entry : this.adrsMap.entrySet()) {
            String string4 = entry.getKey();
            int n = entry.getValue();
            if (bl) {
                stringBuilder.append("<label");
                if (this.isClass && this.cls[n] != null && this.cls[n].length() > 0) {
                    stringBuilder.append(" class=\"").append(this.cls[n]).append('\"');
                }
                stringBuilder.append('>');
            }
            stringBuilder.append(string3).append(string4).append('\"');
            if (string4.equals(string2)) {
                stringBuilder.append(" checked=\"checked\"");
            }
            if (this.isDisable && this.disabled[n] != null && this.disabled[n].length() > 0 && ("false".equalsIgnoreCase(this.disabled[n]) || "0".equals(this.disabled[n]))) {
                stringBuilder.append(" disabled=\"disabled\"");
            }
            stringBuilder.append('>');
            if (!bl) continue;
            stringBuilder.append(this.label[n]).append("</label>");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getValueLabel(String string, boolean bl) {
        Integer n = this.adrsMap.get(string);
        return n == null ? string : this.label[n];
    }

    @Override
    public boolean isTimeOver() {
        return System.currentTimeMillis() - this.createTime > this.DB_CACHE_TIME;
    }

    static {
        boolean bl = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
        if (bl) {
            String string = HybsSystem.sys("SYSTEM_ID");
            APP_INFO = new ApplicationInfo();
            APP_INFO.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            APP_INFO.setModuleInfo("Selection_DBRADIO", null, null);
        } else {
            APP_INFO = null;
        }
    }
}

