/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.system;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipFile;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;

public final class Closer {
    private static final String IO_CLOSE_ERR = "\u30b9\u30c8\u30ea\u30fc\u30e0 close \u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
    private static final String COMMIT_ERR = "Connection \u3092 commit \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
    private static final String ROLLBACK_ERR = "Connection \u3092 rollback \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
    private static final String CONN_CLOSE_ERR = "Connection \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
    private static final String STMT_CLOSE_ERR = "Statement \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
    private static final String RESULT_CLOSE_ERR = "ResultSet \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
    private static final String ZIP_CLOSE_ERR = "ZipFile/JarFile \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
    private static final String UNNONE_ERR = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";

    private Closer() {
    }

    public static boolean ioClose(Closeable closeable) {
        boolean bl = true;
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
            Closer.logWriter(IO_CLOSE_ERR, closeable.toString(), iOException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, closeable.toString(), runtimeException);
        }
        return bl;
    }

    public static boolean commit(Connection connection) {
        boolean bl = true;
        try {
            if (connection != null) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            Closer.logWriter(COMMIT_ERR, sQLException.getSQLState(), sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, runtimeException.getMessage(), runtimeException);
        }
        return bl;
    }

    public static boolean rollback(Connection connection) {
        boolean bl = true;
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            Closer.logWriter(ROLLBACK_ERR, sQLException.getSQLState(), sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, runtimeException.getMessage(), runtimeException);
        }
        return bl;
    }

    public static boolean connClose(Connection connection) {
        boolean bl = true;
        try {
            if (connection != null && !connection.isClosed()) {
                if (connection.isValid(10)) {
                    connection.commit();
                }
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            Closer.logWriter(CONN_CLOSE_ERR, sQLException.getSQLState(), sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, runtimeException.getMessage(), runtimeException);
        }
        return bl;
    }

    public static boolean stmtClose(Statement statement) {
        boolean bl = true;
        try {
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            Closer.logWriter(STMT_CLOSE_ERR, sQLException.getSQLState(), sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, runtimeException.getMessage(), runtimeException);
        }
        return bl;
    }

    public static boolean resultClose(ResultSet resultSet) {
        boolean bl = true;
        try {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Closer.logWriter(RESULT_CLOSE_ERR, sQLException.getSQLState(), sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, runtimeException.getMessage(), runtimeException);
        }
        return bl;
    }

    public static boolean zipClose(ZipFile zipFile) {
        boolean bl = true;
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            Closer.logWriter(ZIP_CLOSE_ERR, zipFile.getName(), iOException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, runtimeException.getMessage(), runtimeException);
        }
        return bl;
    }

    public static boolean autoClose(AutoCloseable autoCloseable) {
        boolean bl = true;
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (Throwable throwable) {
            bl = false;
            Closer.logWriter(UNNONE_ERR, throwable.getMessage(), throwable);
        }
        return bl;
    }

    private static void logWriter(String string, String string2, Throwable throwable) {
        String string3 = string + throwable.getMessage() + ":" + string2 + HybsConst.CR;
        LogWriter.log(string3);
        LogWriter.log(throwable);
    }
}

