<jsp:directive.page pageEncoding="UTF-8" />
<!-- GFM0049 ｶﾗﾑﾘｿｰｽ ⇒ DB定義属性更新 -->

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID_R}" maxRowCount="0">
	select '1' as WRITABLE, '' as TABLE_NAME,A.CLM,COALESCE(B.LNAME,B.NAME_JA,A.NAME_JA) as CLM_NAME,
			A.CLS_NAME,A.RENDERER,A.EDITOR,A.DBTYPE,A.RENDERER_PARAM,A.EDITOR_PARAM,A.TYPE_PARAM,
	--		CASE WHEN A.RENDERER LIKE '%DBMENU'  and UPPER(A.RENDERER_PARAM) LIKE 'SELECT%' THEN A.RENDERER_PARAM
	--			 WHEN A.EDITOR   =    'DATALIST' and UPPER(A.EDITOR_PARAM)   LIKE 'SELECT%' THEN A.EDITOR_PARAM   ELSE '' END AS BIKO,
			A.VIEW_LENGTH,
			case when A.CLS_NAME = 'CLOB' then '' else A.USE_LENGTH end as USE_LENGTH,
			A.DATA_DEFAULT,A.UNIQ,A.SYSTEM_ID,A.KBSAKU
	from GEA03 A left outer join GEA08 B
		on	A.SYSTEM_ID = B.SYSTEM_ID
		and A.CLM		= B.CLM
		and B.LANG		= 'ja'
		and A.FGJ		= B.FGJ
	where A.SYSTEM_ID in ( '{@SYSTEM_ID_R}','**' )
	<og:where startKey="and">
		<og:and value="A.CLM like '{@CLM}'"	/>
	</og:where>
	and   A.FGJ		= '1'
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC, A.CLM
</og:query>

<!-- KBCLM 6:除外 7:共通 8:有閑 9:削除 は対象外 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" scope="request">
	select	'0' as WRITABLE,UPPER(TABLE_NAME) AS TABLE_NAME,UPPER(CLM) AS CLM,CLM_NAME,
			CLS_NAME,RENDERER,EDITOR,DBTYPE,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,
	--		BIKO,
			VIEW_LENGTH,USE_LENGTH,DATA_DEFAULT,UNIQ,SYSTEM_ID,KBSAKU
	from GE82
	where SYSTEM_ID = '{@SYSTEM_ID_D}'
	and   TBLSYU    = '{@TBLSYU}'
	<og:where startKey="and">
		<og:and value="TABLE_NAME	like '{@TABLE_NAME}'"	/>
		<og:and value="CLM			like '{@CLM}'"		/>
		<og:and value="KBSAKU		=    '{@KBSAKU}'"	/>
		<og:and value="SUBSYS		like '{@SUBSYS}'"	/>
	</og:where>
	and		KBCLM	< '6'
	and		FGJ		= '1'
	order by CLM,KBSAKU DESC
</og:query>

<!-- グループ処理では、先行優先 -->
<og:tableMerge
	action        = "DIFFERENCE"
	masterScope   = "session"
	masterKeys    = "CLM"
	diffKeys      = "CLS_NAME,RENDERER,EDITOR,DBTYPE,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,VIEW_LENGTH,USE_LENGTH,DATA_DEFAULT"
	modifyClms    = "UNIQ"
	slaveScope    = "request"
	display       = "true"
/>

<og:value key="lblKey" value="C" />

<!-- UNIQ のみでユニークになるが、安全のため、SYSTEM_IDとTBLSYU,CLM だけは条件に加えておく -->
<!-- TABLE_NAME も条件に入れる場合は、tableMerge の modifyClms で、値をコピーしておく必要がある。 -->

<og:hidden name="SQL">
	UPDATE GE82 SET
			CLS_NAME		= [CLS_NAME],
			RENDERER		= [RENDERER],
			EDITOR			= [EDITOR],
			DBTYPE			= [DBTYPE],
			RENDERER_PARAM	= [RENDERER_PARAM],
			EDITOR_PARAM	= [EDITOR_PARAM],
			TYPE_PARAM		= [TYPE_PARAM],
			VIEW_LENGTH		= [VIEW_LENGTH],
			USE_LENGTH		= [USE_LENGTH],
			DATA_DEFAULT	= [DATA_DEFAULT],
			DYUPD		= '{@USER.YMDH}',
			USRUPD		= '{@USER.ID}',
			PGUPD		= '{@GUI.KEY}'
	WHERE	UNIQ		= [UNIQ]
	AND		SYSTEM_ID	= '{@SYSTEM_ID_D}'
	AND		TBLSYU		= '{@TBLSYU}'
	AND		UPPER(CLM)	= [CLM]
</og:hidden>
