<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJSV3="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query command="NEW">
		SELECT A.ENAME as LABELS
				, A.SAL  as VAL1
				, A.COMM as VAL2
	--			, A.JOB
	--			, B.EMPNO
	--			, B.MGR
	--			, B.HIREDATE
	--			, B.SAL
	--			, B.COMM
	--			, B.DEPTNO
	--			, C.DNAME
	--			, C.LOC
		FROM BONUS A left outer join EMP B
			on A.ENAME = B.ENAME
			left outer join DEPT C
				on B.DEPTNO = C.DEPTNO
		order by B.EMPNO
	</og:query>

	<og:jsChartV3
		chartType		= "{@chartType}"
		labelColumn		= "LABELS"
		title			= "{@chartTitle}"
		indexAxis		= "{@indexAxis}"
		optOptions		= "animation:false"
		optTicks		= "color:'black'"
		debug			= "{@debug}"
		plugins			= "chartLabelPlugin"
	>
		<og:jsChartDataV3
			chartColumn		= "VAL1"
			label			= "{@LBL.SAL}"
			borderColor		= "VIVID"
		/>
		<og:jsChartDataV3
			chartColumn		= "VAL2"
			label			= "{@LBL.COMM}"
			borderColor		= "PASTEL"
		/>
	</og:jsChartV3>

<og:view useScrollBar="false" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
