/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19400A ( PACKAGE BODY )                                               */
/* Created : 2021/06/23 16:36:06                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY GFP19400A AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP19400A
*	処理名			:	一覧登録
*	作成日			:	2007/09/01
*	作成者			:	XXXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF19400A(
	 PO_KEKKA		OUT	NUMBER													-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT	ERR_MSG_ARRAY											-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PI_NAMES		IN	VARCHAR2												-- 項目名
	,PI_SYSARGS		IN	SYSARG_ARRAY											-- ｼｽﾃﾑﾃﾞｰﾀ
	,PI_GF9400ARG	IN	GF9400ARG_ARRAY											-- 登録ﾃﾞｰﾀ配列
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	-- 定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)		:= 'GFP19400A';				-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)		:= PI_SYSARGS(1).PGID;		-- 画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)		:= PI_SYSARGS(1).CDATE;		-- ｼｽﾃﾑ日付
	CON_USER		CONSTANT	VARCHAR2(10)		:= PI_SYSARGS(1).USERID;	-- ﾛｸﾞｲﾝﾕｰｻﾞｰ

	-- 変数定義
	G_I				NUMBER;														-- 行番号
	G_RTN			BOOLEAN;													-- ﾘﾀｰﾝ値
	G_ERRSTP		VARCHAR2(1000)	:= NULL;									-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
	G_DISP_KEY		VARCHAR2(1000)	:= NULL;									-- ｷｰ項目

	-- EXCEPTION定義
	UNMATCH_CDKH	EXCEPTION;

	-- ｻﾞﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	ERROR_CHECK RETURN BOOLEAN;
	FUNCTION	UPDATE_RTN RETURN BOOLEAN;
/*******************************************************************************
*	ERROR_CHECK 入力ｴﾗｰﾁｪｯｸ
*******************************************************************************/
FUNCTION ERROR_CHECK
RETURN BOOLEAN
IS
	L_COUNT	NUMBER	:= 0;
BEGIN
	G_ERRSTP:='ERR_CHARCK';

	G_ERRSTP:='ERR_CHARCK_EXIST_UD';
	-- 存在ﾁｪｯｸ
	SELECT	COUNT(*)
	INTO	L_COUNT
	FROM	GF41
	WHERE	SYSTEM_ID	=	PI_GF9400ARG(G_I).SYSTEM_ID							-- ｼｽﾃﾑID ＝ 画面》ｼｽﾃﾑID
	AND		LANG		=	PI_GF9400ARG(G_I).LANG								-- 言語   ＝ 画面》言語
	AND		CLM			=	PI_GF9400ARG(G_I).CLM								-- 項目   ＝ 画面》項目
	AND		FGJ			IN	('0','1');											-- 状態F  IN ('0','1')

	IF NVL(L_COUNT,0) <= 0 THEN
		--「ﾃﾞｰﾀが存在しません。{0} {1}」
		HYBS.SET_ERRMSGS(PO_ERRMSGS												-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,'GFE0003'												-- ｴﾗｰﾒｯｾｰｼﾞID
						,'{#GF41}'												-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
						,G_DISP_KEY												-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
						);
	END IF;

	RETURN TRUE;
END ERROR_CHECK;
/*******************************************************************************
*	UPDATE_RTN 更新
*******************************************************************************/
FUNCTION UPDATE_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP:='UPDATE_RTN';

	UPDATE	GF41	SET
			 NAME_JA		=	PI_GF9400ARG(G_I).NAME_JA						-- 名称（漢字）
			,LABEL_NAME		=	PI_GF9400ARG(G_I).LABEL_NAME					-- 表示名称
			,KBSAKU			=	PI_GF9400ARG(G_I).KBSAKU						-- 作成区分
			,DYUPD			=	CON_SYSDATE										-- 更新日時
			,PGUPD			=	CON_PGID										-- 更新PG
			,PGPUPD			=	CON_PGPID										-- 更新呼出PG
			,USRUPD			=	CON_USER										-- 更新ﾕｰｻﾞｰ
	WHERE	UNIQ			=	PI_GF9400ARG(G_I).UNIQ;							-- ﾕﾆｰｸ ＝ 画面》ﾕﾆｰｸ

	RETURN TRUE;
END UPDATE_RTN;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='MAIN_S';
	-- 処理結果(2:異常)
	PO_KEKKA := 2;

	G_ERRSTP:='MAIN_ERR_LOOP';
	-- 登録ﾃﾞｰﾀﾁｪｯｸ処理ﾙｰﾌﾟ
	FOR I IN 1..PI_SYSARGS.COUNT LOOP
		G_I	:=	I;
		-- ｷｰ項目ｾｯﾄ
		G_DISP_KEY := ' SYSTEM_ID='|| PI_GF9400ARG(G_I).SYSTEM_ID||
					  ' LANG='|| PI_GF9400ARG(G_I).LANG||
					  ' CLM='|| PI_GF9400ARG(G_I).CLM||
					  ' UNIQ='|| PI_GF9400ARG(G_I).UNIQ;
		-- ｴﾗｰﾁｪｯｸ
		G_RTN := ERROR_CHECK;
	END LOOP;
	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);

	-- 処理結果判定
	IF PO_KEKKA < 2 THEN
		G_ERRSTP:='MAIN_LOOP';
		-- ﾃﾞｰﾀ登録処理ﾙｰﾌﾟ
		FOR I IN 1..PI_SYSARGS.COUNT LOOP
			G_I	:=	I;
			-- ｷｰ項目ｾｯﾄ
			G_DISP_KEY := ' SYSTEM_ID='|| PI_GF9400ARG(G_I).SYSTEM_ID||
						  ' LANG='|| PI_GF9400ARG(G_I).LANG||
						  ' CLM='|| PI_GF9400ARG(G_I).CLM||
						  ' UNIQ='|| PI_GF9400ARG(G_I).UNIQ;
			-- 改廃ｺｰﾄﾞ判定(変更)
			IF PI_SYSARGS(G_I).CDKH = 'C' THEN
				-- 変更処理
				G_RTN := UPDATE_RTN;
			ELSE
				-- 改廃ｺｰﾄﾞｴﾗｰ
				RAISE UNMATCH_CDKH;
			END IF;
		END LOOP;
	END IF;

	G_ERRSTP:='MAIN_E';

	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);

/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	-- 「改廃ｺｰﾄﾞｴﾗｰ 改廃ｺｰﾄﾞ:{0}」
	WHEN UNMATCH_CDKH THEN
		HYBS.SET_ERRMSGS(PO_ERRMSGS												-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,'GFE0004'												-- ｴﾗｰﾒｯｾｰｼﾞID
						,PI_SYSARGS(G_I).CDKH									-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
						);
		PO_KEKKA := 2;
	-- 共通SPｴﾗｰ
	WHEN HYBS.COMMONSP_ERROR THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,'GFE0005'												-- 共通SPｴﾗｰ発生
						,G_DISP_KEY
						);
		PO_KEKKA := 2;
	-- ｵﾗｸﾙｴﾗｰ
	WHEN OTHERS THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		PO_KEKKA := 2;

END GF19400A;
END GFP19400A;
;
