<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC18"
	title	= "JSP解析"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command	= "{@command}"
/>

<!-- 処理結果が false の場合、BODY を表示して終了します。 -->
<og:file action="exists" fileURL="{@JSP_PATH}\{@JSP_DIR}">
	<!-- MSG0087:フォルダが存在していません。 -->
	<og:text>{@LBL.PATH}={@JSP_PATH}\{@JSP_DIR}</og:text>　<og:message lbl="MSG0087" /><br />
	<!-- MSG0088:アクセス可能か確認してください。 -->
	　<og:message lbl="MSG0088" /><br />
</og:file>

<!-- GF70_PROG.xsl ～ GF77_PROG.xsl までを選択します。  -->
<og:value key="XSLT_PATH"	value="{@SYS.REAL_PATH}jsp/{@GUI.ADDRESS}/xslt{@VER}" />
<og:value key="XSL_FILE"	value="GF7{@PROG}_PROG.xsl" />
<og:value key="OUT_FILE"	value="GF7{@PROG}_PROG.xml" />
<og:value key="TBL"			value="GF7{@PROG}" />

<!-- GF77 の時は、FGOMIT と無関係に、対象データを削除する。 -->
<og:value key="FGOMIT"	value=" and FGOMIT='0'" />
<og:equals val1="{@PROG}" val2="7">
	<og:value key="FGOMIT" command="REMOVE" />
</og:equals>

<!-- GF75 の時は、jspInclude は、常に行わない(false) -->
<og:value key="jspInclude2" command="SET" value="{@jspInclude}" />
<og:equals val1="{@PROG}" val2="5">
	<og:value key="jspInclude2" command="SET" value="false" />
</og:equals>

<!-- GF70 の時は、エラー時のデータをXMLに追記する。それ以外は、フォーマットが異なるので、追記できない。 -->
<og:value key="errXmlIn" command="SET" value="false" />
<og:equals val1="{@PROG}" val2="0">
	<og:value key="errXmlIn" command="SET" value="true" />
</og:equals>

<pre>
<og:mainProcess useThread="false" useJspLog="{@debug}" useDisplay="{@display}">
	<og:process processID="FileSearch">
		<og:param key="start"		value="{@JSP_PATH}/{@JSP_DIR}" 	/>
		<og:param key="suffix"		value=".jsp"			/>
		<og:param key="modifyForm"	value="yyyyMMddHHmmss"	/>
		<og:param key="maxLevel"	value="2"				/>
		<og:param key="unmatchDir"	value="backup"			/>
		<og:param key="errAbend"	value="false"			/>
	</og:process>
	<og:process processID="Grep">
		<og:param key="keyword"		value="&lt;jsp:root"	/>
		<og:param key="inEncode"	value="UTF-8"			/>
		<og:param key="errAbend"	value="false"			/>
		<og:param key="display"		value="true"			/>
	</og:process>
	<og:process processID="XSLT">
		<og:param key="xslfile"			value="{@XSLT_PATH}/{@XSL_FILE}" />
		<og:param key="outfile"			value="{@XSLT_PATH}/{@OUT_FILE}" />
		<og:param key="useFileInfo"		value="true" />
		<og:param key="param_SYSTEM_ID"	value="{@SYSTEM_ID}" />
		<og:param key="param_TBLSYU"	value="{@TBLSYU}" />
		<og:param key="param_DYSET"		value="{@USER.YMDH}" />
		<og:param key="header1"			value='&lt;?xml version="1.0" encoding="UTF-8"?&gt;' />
		<og:param key="header2"			value='&lt;ROWSET tableName="{@TBL}"&gt;' />
		<og:param key="header3"			value="&lt;EXEC_SQL&gt;delete from {@TBL} where SYSTEM_ID='{@SYSTEM_ID}' and TBLSYU = '{@TBLSYU}' and FGOMIT='0' &lt;/EXEC_SQL&gt;" />
		<og:param key="footer"			value="&lt;/ROWSET&gt;" />
		<og:param key="errAbend"		value="false" />
		<og:param key="errXmlIn"		value="{@errXmlIn}" />
		<og:param key="jspInclude"		value="{@jspInclude2}" />
		<og:param key="realPath"		value="{@SYS.REAL_PATH}" />				<!-- 5.7.6.2 (2014/05/16) -->
		</og:process>
</og:mainProcess>

<br />
==========================================================================
<br />

<og:text>GF7{@PROG} Table:  </og:text>
<og:directXMLSave
	fileURL		= "{@XSLT_PATH}/"
	filename	= "{@OUT_FILE}"
/>
</pre>

<!-- 6:JSPﾌｧｲﾙ一覧を設定します。 -->
<og:equals val1="{@PROG}" val2="6">
<br />
==========================================================================
<br />
	<jsp:directive.include file="/jsp/DOC18/jspAllInsert.jsp" />
<br />
</og:equals>
==========================================================================
<br />
<!-- DOC10 ～ DOC17 までを選択します。  -->
<og:link gamenId="DOC1{@PROG}" href="index.jsp" target="CONTENTS"
	keys="command,SYSTEM_ID,TBLSYU,FGOMIT" vals="NEW,{@SYSTEM_ID},{@TBLSYU},0" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
