/****************************************************************************/
/* chartLink                                                                */
/* チャートクリック時に呼び出されて、画面を遷移します。                     */
/*                                                                          */
/*   画面IDの有無によるﾀｰｹﾞｯﾄ自動振り分け                                   */
/*   $LBL,$VAL,$IDX,$SEL 記号によるクリック情報の指定                       */
/*   外部指定の配列ﾃﾞｰﾀを引数に追加可能(1件のみ)                            */
/*                                                                          */
/* <og:jsChartV3                                                            */
/*    chartType   = "bar"                                                   */
/*    labelColumn = "ENAME"                                                 */
/*    onClick     = "chartLink( ①event, ②obj, ③null, ④'result.jsp',     */
/*                              ⑤{@JSONDATA}, ⑥'EMPNO', ⑦EMPNO );"       */
/*    varColumns  = "EMPNO"                                                 */
/*    ････                                                                  */
/* >                                                                        */
/*    <og:jsChartDataV3                                                     */
/*        chartColumn = "SAL1"                                              */
/*        ････                                                              */
/*    />                                                                    */
/*                                                                          */
/* 第1引数：ブラウザイベントを定義                                          */
/* 第2引数：チャートのオブジェクトを定義                                    */
/* 第3引数：リンク先の画面IDを指定(null,空文字列の場合は自分自身)           */
/*          gamenId ⇒ ../gamenId/url を生成し、parent ﾀｰｹﾞｯﾄに遷移する     */
/* 第4引数：リンク先のURLを指定                                             */
/* 第5引数：リンク先に渡すJsonｵﾌﾞｼﾞｪｸﾄ形式のﾊﾟﾗﾒｰﾀを指定                    */
/* 第6引数：リンク先に渡すチャートカラムを指定(下記配列のｷｰ文字列)          */
/* 第7引数：チャートのconstの配列変数を指定(jsChartV3#varColumnsで指定)     */
/*                                                                          */
/* @og.rev 8.1.0.4 (2022/01/28) 新規作成                                    */
/* @author LEE.M                                                            */
/****************************************************************************/
const chartLink = function( event, obj, gamenId, url , jsonData, chrtClm, chrtVarAry ) {
	if( obj.length && obj[0] ) {
		const obj0 = obj[0];
		const idx = obj0.index;										// ポイント位置

//		// 無条件に、引数に、commandを設定します。
//		let jsonPrm = {"command":"NEW"} ;							// JSONオブジェクト生成
		let jsonPrm = {} ;											// 空のJSONオブジェクト生成

		// 第5引数:リンク先に渡す引数(jsonData)をマージします。
		Object.assign(jsonPrm,jsonData);

		// 第6引数,第7引数:リンク先に渡すチャートカラムと配列変数の値を指定します。
		if( chrtClm && chrtVarAry && Array.isArray(chrtVarAry) ) {
			jsonPrm[chrtClm] = chrtVarAry[idx] ;					// JSONオブジェクトに追加
		}

		// クリックされた、$LBL,$VAL,$IDX,$SEL を変換します。
		const sel   = obj0.datasetIndex;							// $LBL:グラフ番号
		const data  = event.chart.data;								// $VAL:データ
		const dtLbl = data.labels[idx];								// $IDX:データラベル
		const dtVal = data.datasets[sel].data[idx];					// $SEL:データ値

		// 先に JSON⇒URL引数変換すると、URLｴﾝｺｰﾄﾞ されてしまうので、一旦文字列化します。
		let jsonStr = JSON.stringify(jsonPrm);
		jsonStr = jsonStr.replace("$LBL",dtLbl)
						 .replace("$VAL",dtVal)
						 .replace("$IDX",idx)
						 .replace("$SEL",sel) ;

		// JSON文字列から、JSONｵﾌﾞｼﾞｪｸﾄに戻す。
		jsonPrm = JSON.parse(jsonStr);
		// JSONｵﾌﾞｼﾞｪｸﾄからURLｴﾝｺｰﾄﾞ済みのURLﾊﾟﾗﾒｰﾀを生成する。
		let strUrl = new URLSearchParams( jsonPrm ).toString();

		// 第3引数:画面IDの有無で、ページ遷移のtargetを区別します。
		if( gamenId == null || gamenId == '' ) {
			window.location.href = url + "?" + strUrl;
		} else {
			window.parent.location.href = '../' + gamenId + '/' + url + "?" + strUrl;
		}
	}
}
