<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC21"
	title	= "ﾘｿｰｽ使用検索"
	date	= "2015/06/24"
	author	= "k.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- テキスト索引の同期化 は、とりあえず毎回実行しておきます。(良い方法があれば、教えて) -->
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF76_TXT_IDX' ) }
</og:query>
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF83_TXT_IDX' ) }
</og:query>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- OracleTextで、CONTAINS に CLM をそのまま渡した場合予約語エラーになる為、{} でエスケープする。 -->
	select A.SYSTEM_ID,A.CLM,A.NAME_JA,A.KBLBL,A.FGLOAD,A.FGJ
		from GEA08 A
		where A.SYSTEM_ID = '{@SYSTEM_ID}'
		and   A.CLM is not null
		and   A.LANG      = 'ja'
		and   A.FGJ      in  ('0','1')
		and   A.KBLBL in ( '0','1','2','7','8' )		<!-- 0:一般 1:ｶﾗﾑ 2:ﾃｰﾌﾞﾙ 7:ﾒｯｾｰｼﾞ 8:ｴﾗｰ -->
		<og:equals val1="{@GF76}" val2="true">
			and  not exists (select 1 from GF76 B
					where CONTAINS ( B.FILEPATH, '{' || A.CLM || '}',1 ) &gt; 0
					and   B.SYSTEM_ID = A.SYSTEM_ID
					and   B.TBLSYU    = '{@TBLSYU}'
			)
		</og:equals>
		<og:equals val1="{@DBA_SOURCE}" val2="true">
			and  not exists (select 1 from DBA_SOURCE C
					where C.OWNER = '{@SYSTEM_ID}'
					and   upper(text) like upper( '%' || A.CLM || '%' )
			)
		</og:equals>
		<og:equals val1="{@GF83}" val2="true">
			and not exists (select 1 from GF83 D
					where CONTAINS ( D.SRC_TEXT, '{' || A.CLM || '}',1 ) &gt; 0
					and   D.SYSTEM_ID = A.SYSTEM_ID
					and   D.TBLSYU    = '{@TBLSYU}'
			)
		</og:equals>
		<og:equals val1="{@GF05}" val2="true">
			and not exists (select 1 from GF05 E
					where A.CLM in ( E.CLM , E.TABLE_NAME )
					and   E.SYSTEM_ID = A.SYSTEM_ID
					and   E.TBLSYU    = '{@TBLSYU}'
			)
		</og:equals>
		order by A.CLM,A.NAME_JA
</og:query>

<table><tr><td valign="top">
<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="MODIFY" lbl="FGLOAD.8" columnWritable="FGLOAD,FGJ"
			keys="FGLOAD" vals="8" />
		<og:submit  action="DELETE" />
		<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLTable"
		command		= "{@command}"
		noMessage	= "true"
		checked		= "{@checked}"
		startNo		= "{@startNo}"
		pageSize	= "{@pageSize}"
	/>
</form>
</td>
<td valign="top" >
<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" tableId="INPUT">
	<!-- FGLOAD が、8:未使用 で、先のSQL結果に、存在しないキーは、どこかで使用されている。 -->
	select A.SYSTEM_ID,A.CLM,A.NAME_JA,A.KBLBL,A.FGLOAD,A.FGJ
		from GEA08 A
		where A.SYSTEM_ID = '{@SYSTEM_ID}'
		and   A.CLM is not null
		and   A.LANG      = 'ja'
		and   A.FGJ      in  ('0','1')
		and   A.KBLBL in ( '0','1','2','7','8' )		<!-- 0:一般 1:ｶﾗﾑ 2:ﾃｰﾌﾞﾙ 7:ﾒｯｾｰｼﾞ 8:ｴﾗｰ -->
		and   A.FGLOAD    = '8'							<!-- 現在、8:未使用 のすべての候補 -->
		order by A.CLM,A.NAME_JA
</og:query>

<!-- FGLOAD が、8:未使用 のすべての候補から、使われていないﾘｽﾄ(最初の検索結果)を引く -->
<og:tableMerge
	command			= "{@command}"
	action			= "MINUS"
	masterScope		= "session"
	tableId			= "SABUN"
	masterTableId	= "INPUT"
	masterKeys		= "CLM"
	slaveScope		= "session"
	stopZero		= "true"
	noSideEffect	= "true"
	display			= "true"
/>

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:submit  action="MODIFY" lbl="FGLOAD.0" columnWritable="FGLOAD,FGJ"
			keys="FGLOAD" vals="0" />
		<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLTable"
		command		= "{@command}"
		tableId		= "SABUN"
		mainView	= "false"
		noMessage	= "true"
		checked		= "{@checked}"
		startNo		= "{@startNo}"
		pageSize	= "{@pageSize}"
	/>
	<og:hidden name="tableId" value="SABUN" />
</form>
</td></tr></table>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
