<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7000"
	title	= "郵便番号検索"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select POSTCODE,PREF_KANJI,CITY_KANJI,TOWN_KANJI,BLOCK_KANJI,JIGYO_KANJI,
				CITY_KANA,TOWN_KANA,JIGYO_KANA,JISCODE,POSTCODE_SHORT,CODE_SHU
		from GF42
	<og:where>
		<og:and value = "JISCODE     like '{@PREF_CODE}'"  />
		<og:and value = "POSTCODE    like '{@POSTCODE}'"   />
		<og:and value = "CITY_KANJI  like '{@CITY_KANJI}'" />
		<og:and value = "TOWN_KANJI  like '{@TOWN_KANJI}'" />
		<og:and value = "CITY_KANA   like '{@CITY_KANA}'"  />
		<og:and value = "TOWN_KANA   like '{@TOWN_KANA}'"  />
		<og:and value = "JIGYO_KANJI like '{@JIGYO_KANJI}'"	/>
		<og:and value = "CODE_SHU    =    '{@CODE_SHU}'"	/>
		<og:and value = "BLOCK_KANJI like '{@BLOCK_KANJI}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "JISCODE,TOWN_KANA" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="output"   lbl="Output All" command="NEW" accesskey="R" 
			onClick="return confirm('Output {@LBL.MSG0075}');" />
	<og:submit  value="input"    lbl="Input All"  command="NEW" accesskey="W" 
			onClick="return confirm('Input {@LBL.MSG0075}');" />
	<og:submit  value="jigyosho" lbl="Input Jigyosho"  command="NEW" accesskey="J"
			onClick="return confirm('Jigyosho Input {@LBL.MSG0075}');" />
	<og:submit  value="delete"   lbl="All Delete" command="NEW" accesskey="Z"
			onClick="return confirm('Delete {@LBL.MSG0075}');" />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	rowspan    = "2"
>
	<og:thead rowspan="2">
		<tr><td>[POSTCODE]</td><td>[CITY_KANA]</td><td colspan="2">[TOWN_KANA]</td><td>[JIGYO_KANA]</td></tr>
		<tr><td>[PREF_KANJI]</td><td>[CITY_KANJI]</td><td>[TOWN_KANJI]</td><td>[BLOCK_KANJI]</td><td>[JIGYO_KANJI]</td></tr>
	</og:thead>
</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
