/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedInputStream;							// 8.0.1.0 (2021/10/29)
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

/**
 * ﾌｧｲﾙ操作のｲﾝﾀﾌｪｰｽ
 *
 * ﾛｰｶﾙｻｰﾊﾞ､ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ(AWS,AZURE,BLUEMIX,ORACLE)のﾌｧｲﾙ操作用です｡
 * FileOperationFactoryを通して､ｲﾝｽﾀﾝｽを生成可能です｡
 * Fileｸﾗｽを継承しているため､通常のFileとしても扱えます｡
 *
 * @og.group ﾌｧｲﾙ操作
 *
 * @og.rev 5.10.8.0 (2019/02/01) 新規作成
 * @og.rev 5.10.9.0 (2019/03/01) 変更対応
 * @author oota
 * @since	JDK7.0
 */
public class FileOperation extends File{
	/** このﾌﾟﾛｸﾞﾗﾑのVERSION文字列を設定します｡{@VALUE} */
	private static final String VERSION = "8.0.1.0 (2021/10/29)" ;
	private static final long serialVersionUID = 801020211029L ;

	/** AWSのﾊﾞｹｯﾄなどを使用しない場合の記号 */
	public static final String LOCAL = "LOCAL" ;			// 8.0.1.0 (2021/10/29)

//	private final String myplugin;		// ﾌﾟﾗｸﾞｲﾝ
//	private final String mybucket;		// ﾊﾞｹｯﾄ

	/**
	 * ｺﾝｽﾄﾗｸﾀ
	 *
	 * 初期化処理｡
	 *
	 * @param path ﾌｧｲﾙﾊﾟｽ
	 */
	public FileOperation(final String path) {
		super(path);
	}

//	/**
//	 * ｺﾝｽﾄﾗｸﾀ
//	 *
//	 * FileOperationｸﾗｽでは､buketは使用しません｡
//	 *
//	 * @og.rev 8.0.0.1 (2021/10/08) 削除
//	 *
//	 * @param bucket ﾊﾞｹｯﾄ名
//	 * @param path ﾌｧｲﾙﾊﾟｽ
//	 */
//	public FileOperation(final String bucket, final String path) {
//		this(path);
//		mybucket = bucket;
//	}

	/**
	 * 書き込み処理(評価用)
	 *
	 * Fileを書き込みます｡
	 *
	 * @og.rev 8.0.0.1 (2021/10/08) 新規追加
	 * @param inFile 書き込みFile
	 * @throws IOException ﾌｧｲﾙ関連ｴﾗｰ情報
	 */
	public void write(final File inFile) throws IOException {
		Files.copy(inFile.toPath(), this.toPath(), StandardCopyOption.REPLACE_EXISTING);
	}

	/**
	 * 書き込み処理
	 *
	 * InputStreamのﾃﾞｰﾀを書き込みます｡
	 *
	 * @og.rev 8.0.1.0 (2021/10/29) Paths.get(this.getPath()) → this.toPath() に変更
	 *
	 * @param is 書き込みﾃﾞｰﾀのInputStream
	 * @throws IOException ﾌｧｲﾙ関連ｴﾗｰ情報
	 */
	public void write(final InputStream is) throws IOException {
		// InpustStreamを対象ﾊﾟｽに出力
//		Files.copy(is, Paths.get(this.getPath()), StandardCopyOption.REPLACE_EXISTING);
		Files.copy(is, this.toPath(), StandardCopyOption.REPLACE_EXISTING);
	}

	/**
	 * 読み込み処理
	 *
	 * ﾃﾞｰﾀを読み込み､InputStreamとして､返します｡
	 *
	 * @og.rev 8.0.1.0 (2021/10/29) FileInputStream → BufferedInputStream に変更
	 *
	 * @return 読み込みﾃﾞｰﾀのInputStream
	 * @throws FileNotFoundException ﾌｧｲﾙ非存在ｴﾗｰ情報
	 */
	public InputStream read() throws FileNotFoundException {
//		return new FileInputStream(this.getPath());
		return new BufferedInputStream( new FileInputStream(this));
	}

	/**
	 * ｺﾋﾟｰ処理
	 *
	 * ﾌｧｲﾙを指定先にｺﾋﾟｰします｡
	 *
	 * @og.rev 8.0.1.0 (2021/10/29) Paths.get(this.getPath()) → this.toPath() に変更
	 *
	 * @param afPath ｺﾋﾟｰ先
	 * @return 成否ﾌﾗｸﾞ
	 */
	public boolean copy(final String afPath) {
		boolean flgRtn = false;

		try {
			// 指定ﾊﾟｽのﾌｧｲﾙを､指定先にｺﾋﾟｰ from;jdk7
//			Files.copy(Paths.get(this.getPath()), Paths.get(afPath), StandardCopyOption.REPLACE_EXISTING);
			Files.copy(this.toPath(), Paths.get(afPath), StandardCopyOption.REPLACE_EXISTING);
			flgRtn = true;
		} catch (IOException ie) {
			System.err.println( ie.getMessage() );	// 8.0.0.0 (2021/07/31)
//			;	// ｽﾙｰしてfalseを返す
		}

		return flgRtn;
	}

	/**
	 * ﾌｧｲﾙ移動
	 *
	 * ﾌｧｲﾙを指定先に移動します｡
	 *
	 * @og.rev 8.0.1.0 (2021/10/29) Paths.get(this.getPath()) → this.toPath() に変更
	 *
	 * @param afPath 移動先
	 * @return 成否ﾌﾗｸﾞ
	 */
	public boolean move(final String afPath) {
		boolean flgRtn = false;

		try {
			// 指定ﾊﾟｽのﾌｧｲﾙを､指定先に移動 from:jdk7
//			Files.move(Paths.get(this.getPath()), Paths.get(afPath), StandardCopyOption.REPLACE_EXISTING);
			Files.move(this.toPath(), Paths.get(afPath), StandardCopyOption.REPLACE_EXISTING);
			flgRtn = true;
		} catch (IOException ie) {
			System.err.println( ie.getMessage() );	// 8.0.0.0 (2021/07/31)
//			;	// ｽﾙｰしてfalseを返す
		}
		return flgRtn;
	}

//	/**
//	 * 保存先のﾛｰｶﾙ判定｡
//	 *
//	 * 判定結果を返します｡
//	 * trueの場合は､ﾛｰｶﾙ保存｡
//	 * falseの場合は､ｸﾗｳﾄﾞｽﾄﾚｰｼﾞに保存です｡
//	 *
//	 * @og.rev 8.0.0.1 (2021/10/08) 削除
//	 *
//	 * @return ﾛｰｶﾙﾌﾗｸﾞ
//	 */
//	public boolean isLocal() {
//		return true;
//	}

	/**
	 * 保存先のｸﾗｳﾄﾞ判定｡
	 *
	 * 判定結果を返します｡
	 * trueの場合は､ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ保存｡
	 * falseの場合は､ﾛｰｶﾙに保存です｡
	 *
	 * @og.rev 8.0.0.1 (2021/10/08) ｸﾗｳﾄﾞ修正
	 *
	 * @return ｸﾗｳﾄﾞならtrue
	 */
	public boolean isCloud() {
		return false;
	}

	/**
	 * ｶﾉﾆｶﾙﾌｧｲﾙ取得｡
	 *
	 * ｶﾉﾆｶﾙﾌｧｲﾙ情報を取得します｡
	 *
	 * @throws IOException ﾌｧｲﾙ関連ｴﾗｰ情報
	 * @return ｶﾉﾆｶﾙﾌｧｲﾙ情報
	 */
	@Override
	public FileOperation getCanonicalFile() throws IOException {
		final String canonPath = getCanonicalPath();
		return new FileOperation(canonPath);
	}

	/**
	 * ﾊﾞｹｯﾄ名取得｡
	 *
	 * ﾊﾞｹｯﾄ名を取得します｡
	 * 生のFileOperationは､null を返します｡
	 * 継承先で実際の値を設定してください｡
	 *
	 * @return ﾊﾞｹｯﾄ名
	 */
	public String getBucket() {
//		return mybucket;
		return null;
	}

	/**
	 * ﾌﾟﾗｸﾞｲﾝ名取得｡
	 *
	 * ﾌﾟﾗｸﾞｲﾝ名を取得します｡
	 * 生のFileOperationは､null を返します｡
	 * 継承先で実際の値を設定してください｡
	 *
	 * @return ﾌﾟﾗｸﾞｲﾝ名
	 */
	public String getPlugin() {
//		return this.myplugin;
		return null;
	}

//	/**
//	 * ﾌﾟﾗｸﾞｲﾝ名のｾｯﾄ｡
//	 *
//	 * ﾌﾟﾗｸﾞｲﾝ名をｾｯﾄします｡
//	 *
//	 * @og.rev 8.0.0.1 (2021/10/08) 削除
//	 *
//	 * @param plugin ﾌﾟﾗｸﾞｲﾝ名
//	 */
//	protected void setPlugin( final String plugin ) {
//		myplugin = plugin;
//	}
}
