/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.MessageLoader;
import org.firebirdsql.gds.MessageLookup;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class GDSExceptionHelper {
    private static final Logger log = LoggerFactory.getLogger(GDSExceptionHelper.class);
    private static final Pattern MESSAGE_PARAM_PATTERN = Pattern.compile("\\{(\\d+)}");
    private static final MessageLookup MESSAGE_LOOKUP;

    private GDSExceptionHelper() {
    }

    public static GDSMessage getMessage(int code) {
        String message = MESSAGE_LOOKUP.getErrorMessage(code);
        return new GDSMessage((String)(message != null ? message : "No message for code " + code + " found."));
    }

    public static String getSQLState(int code) {
        return GDSExceptionHelper.getSQLState(code, "HY000");
    }

    public static String getSQLState(int code, String defaultSQLState) {
        String sqlState = MESSAGE_LOOKUP.getSqlState(code);
        return sqlState != null ? sqlState : defaultSQLState;
    }

    static {
        try {
            MESSAGE_LOOKUP = MessageLoader.loadErrorMessages();
        }
        catch (Exception ex) {
            log.error("Exception in init of GDSExceptionHelper, unable to load error information", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static final class GDSMessage {
        private static final int PARAM_SIZE_FACTOR = 20;
        private final String template;
        private final String[] params;
        private final List<String> extraParameters = new ArrayList<String>();

        public GDSMessage(String template) {
            this.template = template;
            this.params = new String[GDSMessage.getParamCountInternal(template)];
        }

        public int getParamCount() {
            return this.params.length;
        }

        private static int getParamCountInternal(String template) {
            int count = 0;
            Matcher matcher = MESSAGE_PARAM_PATTERN.matcher(template);
            while (matcher.find()) {
                ++count;
            }
            return count;
        }

        public void setParameter(int position, String text) {
            if (position < this.params.length) {
                this.params[position] = text;
            }
        }

        public void setParameters(List<String> messageParameters) {
            int position;
            for (position = 0; position < Math.min(this.params.length, messageParameters.size()); ++position) {
                this.params[position] = messageParameters.get(position);
            }
            if (this.params.length < messageParameters.size()) {
                while (position < messageParameters.size()) {
                    this.extraParameters.add(messageParameters.get(position));
                    ++position;
                }
            }
        }

        public String toString() {
            StringBuffer messageBuffer = new StringBuffer(this.estimateBufferCapacity());
            Matcher matcher = MESSAGE_PARAM_PATTERN.matcher(this.template);
            while (matcher.find()) {
                int paramIndex = Integer.parseInt(matcher.group(1));
                String parameterValue = this.isValidParameterIndex(paramIndex) ? this.params[paramIndex] : null;
                matcher.appendReplacement(messageBuffer, "");
                messageBuffer.append(parameterValue != null ? parameterValue : "(null)");
            }
            matcher.appendTail(messageBuffer);
            for (String extraParameter : this.extraParameters) {
                messageBuffer.append("; ").append(extraParameter);
            }
            return messageBuffer.toString();
        }

        private int estimateBufferCapacity() {
            return this.template.length() + (this.params.length + this.extraParameters.size()) * 20;
        }

        private boolean isValidParameterIndex(int index) {
            return index >= 0 && index < this.params.length;
        }
    }
}

