/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.BlobLengthProcessor;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbBlob
implements FbBlob,
TransactionListener,
DatabaseListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbBlob.class);
    private final Object syncObject;
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private final BlobParameterBuffer blobParameterBuffer;
    private FbTransaction transaction;
    private FbDatabase database;
    private boolean open;
    private boolean eof;

    protected AbstractFbBlob(FbDatabase database, FbTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        this.syncObject = database.getSynchronizationObject();
        this.database = database;
        this.transaction = transaction;
        this.blobParameterBuffer = blobParameterBuffer;
        transaction.addWeakTransactionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOpen() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEof() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.eof || !this.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setEof() {
        if (this.isOutput()) {
            return;
        }
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.eof = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void resetEof() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.eof = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setOpen(boolean open) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            FbDatabase database = this.database;
            if (open) {
                database.addWeakDatabaseListener(this);
            } else {
                database.removeDatabaseListener(this);
                FbTransaction transaction = this.transaction;
                if (transaction != null) {
                    transaction.removeTransactionListener(this);
                }
            }
            this.open = open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                block15: {
                    if (this.isOpen()) break block15;
                    return;
                }
                try {
                    if (this.isEndingTransaction()) {
                        this.releaseResources();
                    } else {
                        this.checkDatabaseAttached();
                        this.checkTransactionActive();
                        this.closeImpl();
                    }
                }
                finally {
                    this.setOpen(false);
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected abstract void closeImpl() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    if (this.isEndingTransaction()) {
                        this.releaseResources();
                    } else {
                        this.checkDatabaseAttached();
                        this.checkTransactionActive();
                        this.cancelImpl();
                    }
                }
                finally {
                    this.setOpen(false);
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected abstract void cancelImpl() throws SQLException;

    protected abstract void releaseResources();

    @Override
    public final Object getSynchronizationObject() {
        return this.syncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        if (this.getTransaction() != transaction) {
            transaction.removeTransactionListener(this);
            return;
        }
        switch (newState) {
            case COMMITTING: 
            case ROLLING_BACK: 
            case PREPARING: {
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.error("Exception while closing blob during transaction end", e);
                }
                break;
            }
            case COMMITTED: 
            case ROLLED_BACK: {
                Object object = this.getSynchronizationObject();
                synchronized (object) {
                    this.clearTransaction();
                    this.setOpen(false);
                    this.releaseResources();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detaching(FbDatabase database) {
        if (this.database != database) {
            database.removeDatabaseListener(this);
            return;
        }
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.isOpen()) {
                log.debug(String.format("blob with blobId %d still open on database detach", this.getBlobId()));
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.error("Blob close in detaching event failed", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detached(FbDatabase database) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.database == database) {
                this.open = false;
                this.clearDatabase();
                this.clearTransaction();
                this.releaseResources();
            }
        }
        database.removeDatabaseListener(this);
    }

    @Override
    public void warningReceived(FbDatabase database, SQLWarning warning) {
    }

    protected final boolean isEndingTransaction() {
        FbTransaction transaction = this.getTransaction();
        if (transaction != null) {
            TransactionState transactionState = transaction.getState();
            return transactionState == TransactionState.COMMITTING || transactionState == TransactionState.ROLLING_BACK || transactionState == TransactionState.PREPARING;
        }
        return false;
    }

    protected final void checkTransactionActive() throws SQLException {
        TransactionHelper.checkTransactionActive(this.getTransaction(), 335544370);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDatabaseAttached() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.database == null || !this.database.isAttached()) {
                throw new FbExceptionBuilder().nonTransientException(335544372).toSQLException();
            }
        }
    }

    protected void checkBlobOpen() throws SQLException {
        if (!this.isOpen()) {
            throw new FbExceptionBuilder().nonTransientException(335544328).toSQLException();
        }
    }

    protected void checkBlobClosed() throws SQLException {
        if (this.isOpen()) {
            throw new FbExceptionBuilder().nonTransientException(335544355).toSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FbTransaction getTransaction() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearTransaction() {
        FbTransaction transaction;
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            transaction = this.transaction;
            this.transaction = null;
        }
        if (transaction != null) {
            transaction.removeTransactionListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FbDatabase getDatabase() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.database;
        }
    }

    @Override
    public <T> T getBlobInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] blobInfo = this.getBlobInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(blobInfo);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                if (this.getBlobId() == 0L) {
                    throw new FbExceptionBuilder().exception(335544329).toSQLException();
                }
                BlobLengthProcessor blobLengthProcessor = this.createBlobLengthProcessor();
                return this.getBlobInfo(blobLengthProcessor.getBlobLengthItems(), 20, blobLengthProcessor);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearDatabase() {
        FbDatabase database;
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            database = this.database;
            this.database = null;
        }
        if (database != null) {
            database.removeDatabaseListener(this);
        }
    }

    protected BlobParameterBuffer getBlobParameterBuffer() {
        return this.blobParameterBuffer;
    }

    protected BlobLengthProcessor createBlobLengthProcessor() {
        return new BlobLengthProcessor(this);
    }

    @Override
    public int getMaximumSegmentSize() {
        return 32765;
    }
}

