/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public abstract class AbstractFbWireStatement
extends AbstractFbStatement
implements FbWireStatement {
    private final Map<RowDescriptor, byte[]> blrCache = Collections.synchronizedMap(new WeakHashMap());
    private volatile int handle = 65535;
    private FbWireDatabase database;

    public AbstractFbWireStatement(FbWireDatabase database) {
        super(database.getSynchronizationObject());
        this.database = database;
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    private XdrStreamAccess getXdrStreamAccess() throws SQLException {
        if (this.database != null) {
            return this.database.getXdrStreamAccess();
        }
        throw new SQLException("Connection closed or no connection available");
    }

    @Override
    public final FbWireDatabase getDatabase() {
        return this.database;
    }

    @Override
    public final int getHandle() {
        return this.handle;
    }

    protected final void setHandle(int handle) {
        this.handle = handle;
    }

    protected final byte[] calculateBlr(RowDescriptor rowDescriptor) throws SQLException {
        if (rowDescriptor == null) {
            return null;
        }
        byte[] blr = this.blrCache.get(rowDescriptor);
        if (blr == null) {
            blr = this.getDatabase().getBlrCalculator().calculateBlr(rowDescriptor);
            this.blrCache.put(rowDescriptor, blr);
        }
        return blr;
    }

    protected final byte[] calculateBlr(RowDescriptor rowDescriptor, RowValue rowValue) throws SQLException {
        if (rowDescriptor == null || rowValue == null) {
            return null;
        }
        return this.getDatabase().getBlrCalculator().calculateBlr(rowDescriptor, rowValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.database = null;
                this.blrCache.clear();
            }
        }
    }

    @Override
    protected boolean isValidTransactionClass(Class<? extends FbTransaction> transactionClass) {
        return FbWireTransaction.class.isAssignableFrom(transactionClass);
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.database.emptyRowDescriptor();
    }
}

