/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.resource.ResourceException;
import javax.transaction.xa.Xid;
import org.firebirdsql.jca.FBIncorrectXidException;
import org.firebirdsql.jca.FBResourceException;

class FBXid
implements Xid {
    public static final int TDR_VERSION = 1;
    public static final int TDR_HOST_SITE = 1;
    public static final int TDR_DATABASE_PATH = 2;
    public static final int TDR_TRANSACTION_ID = 3;
    public static final int TDR_REMOTE_SITE = 4;
    public static final int TDR_XID_FORMAT_ID = 5;
    public static final int TDR_XID_GLOBAL_ID = 6;
    public static final int TDR_XID_BRANCH_ID = 4;
    private int formatId;
    private final byte[] globalId;
    private final byte[] branchId;
    private final long firebirdTransactionId;

    static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        Object s = id.getClass().getName();
        s = ((String)s).substring(((String)s).lastIndexOf(46) + 1);
        s = (String)s + " [FormatId=" + id.getFormatId() + ", GlobalId=" + new String(id.getGlobalTransactionId()).trim() + ", BranchQual=" + new String(id.getBranchQualifier()).trim() + "]";
        return s;
    }

    public FBXid(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalId = xid.getGlobalTransactionId();
        this.branchId = xid.getBranchQualifier();
        this.firebirdTransactionId = 0L;
    }

    FBXid(InputStream rawIn, long firebirdTransactionId) throws ResourceException {
        this.firebirdTransactionId = firebirdTransactionId;
        try {
            if (this.read(rawIn) != 1) {
                throw new FBIncorrectXidException("Wrong TDR_VERSION for xid");
            }
            if (this.read(rawIn) != 5) {
                throw new FBIncorrectXidException("Wrong TDR_XID_FORMAT_ID for xid");
            }
            this.formatId = this.readInt(rawIn);
            if (this.read(rawIn) != 6) {
                throw new FBIncorrectXidException("Wrong TDR_XID_GLOBAL_ID for xid");
            }
            this.globalId = this.readBuffer(rawIn);
            if (this.read(rawIn) != 4) {
                throw new FBIncorrectXidException("Wrong TDR_XID_BRANCH_ID for xid");
            }
            this.branchId = this.readBuffer(rawIn);
        }
        catch (IOException ioe) {
            throw new FBResourceException("IOException: " + ioe, ioe);
        }
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public long getFirebirdTransactionId() {
        return this.firebirdTransactionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)obj;
        boolean result = this.formatId == other.getFormatId();
        byte[] otherGlobalID = other.getGlobalTransactionId();
        byte[] otherBranchID = other.getBranchQualifier();
        result &= Arrays.equals(this.globalId, otherGlobalID);
        return result &= Arrays.equals(this.branchId, otherBranchID);
    }

    public int hashCode() {
        int hashCode = 1109;
        hashCode = 43 * hashCode + this.formatId;
        hashCode = 43 * hashCode + Arrays.hashCode(this.globalId);
        hashCode = 43 * hashCode + Arrays.hashCode(this.branchId);
        return hashCode;
    }

    public String toString() {
        return FBXid.toString(this);
    }

    int getLength() {
        return 11 + this.globalId.length + 1 + 4 + this.branchId.length;
    }

    byte[] toBytes() {
        byte[] b = new byte[this.getLength()];
        int i = 0;
        b[i++] = 1;
        b[i++] = 5;
        b[i++] = (byte)(this.formatId >>> 24 & 0xFF);
        b[i++] = (byte)(this.formatId >>> 16 & 0xFF);
        b[i++] = (byte)(this.formatId >>> 8 & 0xFF);
        b[i++] = (byte)(this.formatId & 0xFF);
        b[i++] = 6;
        b[i++] = (byte)(this.globalId.length >>> 24 & 0xFF);
        b[i++] = (byte)(this.globalId.length >>> 16 & 0xFF);
        b[i++] = (byte)(this.globalId.length >>> 8 & 0xFF);
        b[i++] = (byte)(this.globalId.length & 0xFF);
        System.arraycopy(this.globalId, 0, b, i, this.globalId.length);
        i += this.globalId.length;
        b[i++] = 4;
        b[i++] = (byte)(this.branchId.length >>> 24 & 0xFF);
        b[i++] = (byte)(this.branchId.length >>> 16 & 0xFF);
        b[i++] = (byte)(this.branchId.length >>> 8 & 0xFF);
        b[i++] = (byte)(this.branchId.length & 0xFF);
        System.arraycopy(this.branchId, 0, b, i, this.branchId.length);
        return b;
    }

    private int read(InputStream in) throws IOException {
        return in.read();
    }

    private int readInt(InputStream in) throws IOException {
        return this.read(in) << 24 | this.read(in) << 16 | this.read(in) << 8 | this.read(in);
    }

    private byte[] readBuffer(InputStream in) throws IOException {
        int len = this.readInt(in);
        byte[] buffer = new byte[len];
        this.readFully(in, buffer, 0, len);
        return buffer;
    }

    private void readFully(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int counter;
        if (length == 0) {
            return;
        }
        do {
            if ((counter = in.read(buffer, offset, length)) == -1) {
                throw new EOFException();
            }
            offset += counter;
        } while ((length -= counter) > 0);
    }
}

