/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class HeadersFootersAtom
extends RecordAtom {
    public static final int fHasDate = 1;
    public static final int fHasTodayDate = 2;
    public static final int fHasUserDate = 4;
    public static final int fHasSlideNumber = 8;
    public static final int fHasHeader = 16;
    public static final int fHasFooter = 32;
    private static final int[] PLACEHOLDER_MASKS = new int[]{1, 2, 4, 8, 16, 32};
    private static final String[] PLACEHOLDER_NAMES = new String[]{"DATE", "TODAY_DATE", "USER_DATE", "SLIDE_NUMBER", "HEADER", "FOOTER"};
    private final byte[] _header;
    private final byte[] _recdata;

    protected HeadersFootersAtom(byte[] source, int start, int len) {
        this._header = Arrays.copyOfRange(source, start, start + 8);
        this._recdata = IOUtils.safelyClone((byte[])source, (int)(start + 8), (int)(len - 8), (int)HeadersFootersAtom.getMaxRecordLength());
    }

    public HeadersFootersAtom() {
        this._recdata = new byte[4];
        this._header = new byte[8];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._recdata.length);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.HeadersFootersAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._recdata);
    }

    public int getFormatId() {
        return LittleEndian.getShort((byte[])this._recdata, (int)0);
    }

    public void setFormatId(int formatId) {
        LittleEndian.putUShort((byte[])this._recdata, (int)0, (int)formatId);
    }

    public int getMask() {
        return LittleEndian.getShort((byte[])this._recdata, (int)2);
    }

    public void setMask(int mask) {
        LittleEndian.putUShort((byte[])this._recdata, (int)2, (int)mask);
    }

    public boolean getFlag(int bit) {
        return (this.getMask() & bit) != 0;
    }

    public void setFlag(int bit, boolean value) {
        int mask = this.getMask();
        mask = value ? (mask |= bit) : (mask &= ~bit);
        this.setMask(mask);
    }

    public String toString() {
        return "HeadersFootersAtom\n\tFormatId: " + this.getFormatId() + "\n\tMask    : " + this.getMask() + "\n\t  fHasDate        : " + this.getFlag(1) + "\n\t  fHasTodayDate   : " + this.getFlag(2) + "\n\t  fHasUserDate    : " + this.getFlag(4) + "\n\t  fHasSlideNumber : " + this.getFlag(8) + "\n\t  fHasHeader      : " + this.getFlag(16) + "\n\t  fHasFooter      : " + this.getFlag(32) + "\n";
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"formatIndex", (Supplier)GenericRecordUtil.safeEnum((Enum[])FormatIndex.values(), this::getFormatId), (String)"flags", (Supplier)GenericRecordUtil.getBitsAsString(this::getMask, (int[])PLACEHOLDER_MASKS, (String[])PLACEHOLDER_NAMES));
    }

    public static enum FormatIndex {
        SHORT_DATE,
        LONG_DATE,
        LONG_DATE_WITHOUT_WEEKDAY,
        ALTERNATE_SHORT_DATE,
        ISO_STANDARD_DATE,
        SHORT_DATE_WITH_ABBREVIATED_MONTH,
        SHORT_DATE_WITH_SLASHES,
        ALTERNATE_SHORT_DATE_WITH_ABBREVIATED_MONTH,
        ENGLISH_DATE,
        MONTH_AND_YEAR,
        ABBREVIATED_MONTH_AND_YEAR,
        DATE_AND_HOUR12_TIME,
        DATE_AND_HOUR12_TIME_WITH_SECONDS,
        HOUR12_TIME,
        HOUR12_TIME_WITH_SECONDS,
        HOUR24_TIME,
        HOUR24_TIME_WITH_SECONDS,
        CHINESE1,
        CHINESE2,
        CHINESE3;

    }
}

