/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.firebirdsql.gds.GDSExceptionHelper;
import org.firebirdsql.gds.ng.wire.crypt.FBSQLEncryptException;
import org.firebirdsql.jdbc.FBSQLExceptionInfo;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public final class FbExceptionBuilder {
    private static final String SQLSTATE_FEATURE_NOT_SUPPORTED_PREFIX = "0A";
    private static final String SQLSTATE_SYNTAX_ERROR_PREFIX = "42";
    private static final String SQLSTATE_CONNECTION_ERROR_PREFIX = "08";
    private final List<ExceptionInformation> exceptionInfo = new ArrayList<ExceptionInformation>();
    private ExceptionInformation current = null;
    private static final Integer[] UNINTERESTING_ERROR_CODES_ARR = new Integer[]{0, 335544569, 336397208, 336397209, 335544436, 335544570, 0x14000001, 335544794};
    private static final Set<Integer> UNINTERESTING_ERROR_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(UNINTERESTING_ERROR_CODES_ARR)));
    private static final String SQLSTATE_SUCCESS = "00000";
    private static final int[] NON_TRANSIENT_CODES = new int[]{335545064, 335545065, 335545066, 335545067, 337248280, 337248281, 337248282, 335544472};
    private static final int[] TIMEOUT_CODES = new int[]{335545127, 335545128, 335545129};

    public FbExceptionBuilder exception(int errorCode) {
        this.setNextExceptionInformation(Type.EXCEPTION, errorCode);
        return this;
    }

    public static FbExceptionBuilder forException(int errorCode) {
        return new FbExceptionBuilder().exception(errorCode);
    }

    public static FbExceptionBuilder forWarning(int errorCode) {
        return new FbExceptionBuilder().warning(errorCode);
    }

    public FbExceptionBuilder warning(int errorCode) {
        this.setNextExceptionInformation(Type.WARNING, errorCode);
        return this;
    }

    public FbExceptionBuilder timeoutException(int errorCode) {
        this.setNextExceptionInformation(Type.TIMEOUT, errorCode);
        return this;
    }

    public FbExceptionBuilder nonTransientException(int errorCode) {
        this.setNextExceptionInformation(Type.NON_TRANSIENT, errorCode);
        return this;
    }

    public FbExceptionBuilder nonTransientConnectionException(int errorCode) {
        this.setNextExceptionInformation(Type.NON_TRANSIENT_CONNECT, errorCode);
        return this;
    }

    public FbExceptionBuilder messageParameter(int parameter) {
        return this.messageParameter(Integer.toString(parameter));
    }

    public FbExceptionBuilder messageParameter(String parameter) {
        this.checkExceptionInformation();
        this.current.addMessageParameter(parameter);
        return this;
    }

    public FbExceptionBuilder sqlState(String sqlState) {
        this.checkExceptionInformation();
        this.current.setSqlState(sqlState);
        return this;
    }

    public FbExceptionBuilder cause(Throwable cause) {
        this.checkExceptionInformation();
        this.current.setCause(cause);
        return this;
    }

    public SQLException toSQLException() {
        this.checkNonEmpty();
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        for (ExceptionInformation info : this.exceptionInfo) {
            chain.append(info.toSQLException());
        }
        return chain.getException();
    }

    public SQLException toFlatSQLException() {
        this.checkNonEmpty();
        SQLExceptionChainBuilder<FBSQLExceptionInfo> chain = new SQLExceptionChainBuilder<FBSQLExceptionInfo>();
        StringBuilder fullExceptionMessage = new StringBuilder();
        ExceptionInformation interestingExceptionInfo = null;
        for (ExceptionInformation info : this.exceptionInfo) {
            if (interestingExceptionInfo == null && !UNINTERESTING_ERROR_CODES.contains(info.errorCode) && !SQLSTATE_SUCCESS.equals(info.sqlState)) {
                interestingExceptionInfo = info;
            }
            if (fullExceptionMessage.length() > 0) {
                fullExceptionMessage.append("; ");
            }
            fullExceptionMessage.append(info.toMessage());
            chain.append(info.toSQLExceptionInfo());
        }
        ExceptionInformation firstExceptionInfo = this.exceptionInfo.get(0);
        if (interestingExceptionInfo == null) {
            interestingExceptionInfo = firstExceptionInfo;
        }
        fullExceptionMessage.append(" [SQLState:").append(interestingExceptionInfo.sqlState).append(", ISC error code:").append(interestingExceptionInfo.errorCode).append(']');
        Type exceptionType = firstExceptionInfo.type != Type.EXCEPTION ? firstExceptionInfo.type : interestingExceptionInfo.type;
        SQLException exception = exceptionType.createSQLException(fullExceptionMessage.toString(), interestingExceptionInfo.sqlState, interestingExceptionInfo.errorCode);
        exception.initCause((Throwable)chain.getException());
        return exception;
    }

    private void checkNonEmpty() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No information available to build an SQLException");
        }
    }

    public <T extends SQLException> T toSQLException(Class<T> type) throws ClassCastException {
        return (T)((SQLException)type.cast(this.toSQLException()));
    }

    public <T extends SQLException> T toFlatSQLException(Class<T> type) throws ClassCastException {
        return (T)((SQLException)type.cast(this.toFlatSQLException()));
    }

    public boolean isEmpty() {
        return this.exceptionInfo.isEmpty();
    }

    public String toString() {
        if (this.current == null) {
            return "empty";
        }
        return this.exceptionInfo.toString();
    }

    private void setNextExceptionInformation(Type type, int errorCode) {
        this.current = new ExceptionInformation(FbExceptionBuilder.upgradeType(type, errorCode), errorCode);
        this.exceptionInfo.add(this.current);
    }

    private static Type upgradeType(Type type, int errorCode) {
        switch (type) {
            case WARNING: {
                return type;
            }
            case EXCEPTION: {
                if (Arrays.binarySearch(NON_TRANSIENT_CODES, errorCode) >= 0) {
                    return Type.NON_TRANSIENT;
                }
                if (Arrays.binarySearch(TIMEOUT_CODES, errorCode) >= 0) {
                    return Type.TIMEOUT;
                }
                return type;
            }
        }
        return type;
    }

    private void checkExceptionInformation() throws IllegalStateException {
        if (this.current == null) {
            throw new IllegalStateException("FbExceptionBuilder requires call to warning() or exception() first");
        }
    }

    static {
        Arrays.sort(NON_TRANSIENT_CODES);
        Arrays.sort(TIMEOUT_CODES);
    }

    private static enum Type {
        EXCEPTION("HY000"){

            @Override
            public SQLException createSQLException(String message, String sqlState, int errorCode) {
                if (sqlState != null) {
                    if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_FEATURE_NOT_SUPPORTED_PREFIX)) {
                        return new SQLFeatureNotSupportedException(message, sqlState, errorCode);
                    }
                    if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_SYNTAX_ERROR_PREFIX)) {
                        return new SQLSyntaxErrorException(message, sqlState, errorCode);
                    }
                }
                return new SQLException(message, sqlState, errorCode);
            }
        }
        ,
        WARNING("01000"){

            @Override
            public SQLException createSQLException(String message, String sqlState, int errorCode) {
                return new SQLWarning(message, sqlState, errorCode);
            }
        }
        ,
        TIMEOUT("HY000"){

            @Override
            public SQLException createSQLException(String message, String sqlState, int errorCode) {
                return new SQLTimeoutException(message, sqlState, errorCode);
            }
        }
        ,
        NON_TRANSIENT("HY000"){

            @Override
            public SQLException createSQLException(String message, String sqlState, int errorCode) {
                switch (errorCode) {
                    case 335545064: 
                    case 335545065: 
                    case 335545066: 
                    case 335545067: 
                    case 337248280: 
                    case 337248281: 
                    case 337248282: {
                        return new FBSQLEncryptException(message, sqlState, errorCode);
                    }
                    case 335544472: {
                        return new SQLInvalidAuthorizationSpecException(message, sqlState, errorCode);
                    }
                }
                if (sqlState != null) {
                    if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_SYNTAX_ERROR_PREFIX)) {
                        return new SQLSyntaxErrorException(message, sqlState, errorCode);
                    }
                    if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_CONNECTION_ERROR_PREFIX)) {
                        return new SQLNonTransientConnectionException(message, sqlState, errorCode);
                    }
                }
                return new SQLNonTransientException(message, sqlState, errorCode);
            }
        }
        ,
        NON_TRANSIENT_CONNECT("08000"){

            @Override
            public SQLException createSQLException(String message, String sqlState, int errorCode) {
                return new SQLNonTransientConnectionException(message, sqlState, errorCode);
            }
        };

        private final String defaultSQLState;

        private Type(String defaultSQLState) {
            this.defaultSQLState = defaultSQLState;
        }

        public final String getDefaultSQLState() {
            return this.defaultSQLState;
        }

        public abstract SQLException createSQLException(String var1, String var2, int var3);
    }

    private static final class ExceptionInformation {
        private final Type type;
        private final List<String> messageParameters = new ArrayList<String>();
        private final int errorCode;
        private String sqlState;
        private Throwable cause;

        ExceptionInformation(Type type, int errorCode) {
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            this.type = type;
            this.errorCode = errorCode;
            this.sqlState = GDSExceptionHelper.getSQLState(errorCode, type.getDefaultSQLState());
        }

        void setSqlState(String sqlState) {
            if (sqlState == null || sqlState.length() != 5) {
                throw new IllegalArgumentException("Value of sqlState must be a 5 character string");
            }
            this.sqlState = sqlState;
        }

        void setCause(Throwable cause) {
            this.cause = cause;
        }

        void addMessageParameter(String argument) {
            this.messageParameters.add(argument);
        }

        List<String> getMessageParameters() {
            return Collections.unmodifiableList(this.messageParameters);
        }

        String toMessage() {
            GDSExceptionHelper.GDSMessage gdsMessage = GDSExceptionHelper.getMessage(this.errorCode);
            gdsMessage.setParameters(this.getMessageParameters());
            return gdsMessage.toString();
        }

        SQLException toSQLException() {
            String message = this.toMessage() + " [SQLState:" + this.sqlState + ", ISC error code:" + this.errorCode + "]";
            SQLException result = this.type.createSQLException(message, this.sqlState, this.errorCode);
            if (this.cause != null) {
                result.initCause(this.cause);
            }
            return result;
        }

        FBSQLExceptionInfo toSQLExceptionInfo() {
            FBSQLExceptionInfo result = new FBSQLExceptionInfo(this.toMessage(), this.sqlState, this.errorCode);
            if (this.cause != null) {
                result.initCause(this.cause);
            }
            return result;
        }

        public String toString() {
            return "Type: " + this.type + "; ErrorCode: " + this.errorCode + "; Message: \"" + this.toMessage() + "\"; SQLstate: " + this.sqlState + "; MessageParameters: " + this.getMessageParameters() + "; Cause: " + this.cause;
        }
    }
}

