/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import jj2000.j2k.IntegerSpec;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.wavelet.synthesis.SynWTFilterSpec;

public class DecoderSpecs
implements Cloneable {
    public ModuleSpec iccs;
    public MaxShiftSpec rois;
    public QuantTypeSpec qts;
    public QuantStepSizeSpec qsss;
    public GuardBitsSpec gbs;
    public SynWTFilterSpec wfs;
    public IntegerSpec dls;
    public IntegerSpec nls;
    public IntegerSpec pos;
    public ModuleSpec ecopts;
    public CompTransfSpec cts;
    public ModuleSpec pcs;
    public ModuleSpec ers;
    public PrecinctSizeSpec pss;
    public ModuleSpec sops;
    public ModuleSpec ephs;
    public CBlkSizeSpec cblks;
    public ModuleSpec pphs;

    public DecoderSpecs getCopy() {
        DecoderSpecs decoderSpecs;
        try {
            decoderSpecs = (DecoderSpecs)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Cannot clone the DecoderSpecs instance");
        }
        decoderSpecs.qts = (QuantTypeSpec)this.qts.getCopy();
        decoderSpecs.qsss = (QuantStepSizeSpec)this.qsss.getCopy();
        decoderSpecs.gbs = (GuardBitsSpec)this.gbs.getCopy();
        decoderSpecs.wfs = (SynWTFilterSpec)this.wfs.getCopy();
        decoderSpecs.dls = (IntegerSpec)this.dls.getCopy();
        decoderSpecs.cts = (CompTransfSpec)this.cts.getCopy();
        if (this.rois != null) {
            decoderSpecs.rois = (MaxShiftSpec)this.rois.getCopy();
        }
        return decoderSpecs;
    }

    public DecoderSpecs(int n, int n2) {
        this.qts = new QuantTypeSpec(n, n2, 2);
        this.qsss = new QuantStepSizeSpec(n, n2, 2);
        this.gbs = new GuardBitsSpec(n, n2, 2);
        this.wfs = new SynWTFilterSpec(n, n2, 2);
        this.dls = new IntegerSpec(n, n2, 2);
        this.cts = new CompTransfSpec(n, n2, 2);
        this.ecopts = new ModuleSpec(n, n2, 2);
        this.ers = new ModuleSpec(n, n2, 2);
        this.cblks = new CBlkSizeSpec(n, n2, 2);
        this.pss = new PrecinctSizeSpec(n, n2, 2, this.dls);
        this.nls = new IntegerSpec(n, n2, 1);
        this.pos = new IntegerSpec(n, n2, 1);
        this.pcs = new ModuleSpec(n, n2, 1);
        this.sops = new ModuleSpec(n, n2, 1);
        this.ephs = new ModuleSpec(n, n2, 1);
        this.pphs = new ModuleSpec(n, n2, 1);
        this.iccs = new ModuleSpec(n, n2, 1);
        this.pphs.setDefault(new Boolean(false));
    }
}

