/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageio.plugins.pnm.PNMImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import com.sun.media.imageioimpl.plugins.pnm.PNMMetadata;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import sun.security.action.GetPropertyAction;

public class PNMImageWriter
extends ImageWriter {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.imageioimpl.PNMImageWriter";
    private static byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private ImageOutputStream stream = null;

    public PNMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("PNMImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new PNMImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new PNMMetadata(imageTypeSpecifier, imageWriteParam);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        PNMMetadata pNMMetadata = null;
        if (iIOMetadata instanceof PNMMetadata) {
            pNMMetadata = (PNMMetadata)((PNMMetadata)iIOMetadata).clone();
        } else {
            try {
                pNMMetadata = new PNMMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                pNMMetadata = new PNMMetadata();
            }
        }
        pNMMetadata.initialize(imageTypeSpecifier, imageWriteParam);
        return pNMMetadata;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        boolean bl;
        boolean bl2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n;
        int[] nArray;
        int n2;
        int n3;
        int n4;
        SampleModel sampleModel;
        Rectangle rectangle;
        boolean bl3;
        Raster raster;
        RenderedImage renderedImage;
        block80: {
            SampleModel sampleModel2;
            ColorModel colorModel;
            block79: {
                int n5;
                ImageTypeSpecifier imageTypeSpecifier;
                Object object;
                this.clearAbortRequest();
                this.processImageStarted(0);
                if (imageWriteParam == null) {
                    imageWriteParam = this.getDefaultWriteParam();
                }
                renderedImage = null;
                raster = null;
                bl3 = iIOImage.hasRaster();
                rectangle = imageWriteParam.getSourceRegion();
                sampleModel = null;
                colorModel = null;
                if (bl3) {
                    raster = iIOImage.getRaster();
                    sampleModel = raster.getSampleModel();
                    rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
                } else {
                    renderedImage = iIOImage.getRenderedImage();
                    sampleModel = renderedImage.getSampleModel();
                    colorModel = renderedImage.getColorModel();
                    Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
                    rectangle = rectangle == null ? rectangle2 : rectangle.intersection(rectangle2);
                }
                if (rectangle.isEmpty()) {
                    throw new RuntimeException(I18N.getString("PNMImageWrite1"));
                }
                ImageUtil.canEncodeImage(this, colorModel, sampleModel);
                n4 = imageWriteParam.getSourceXSubsampling();
                n3 = imageWriteParam.getSourceYSubsampling();
                int n6 = imageWriteParam.getSubsamplingXOffset();
                int n7 = imageWriteParam.getSubsamplingYOffset();
                rectangle.translate(n6, n7);
                rectangle.width -= n6;
                rectangle.height -= n7;
                int n8 = rectangle.x / n4;
                int n9 = rectangle.y / n3;
                n2 = (rectangle.width + n4 - 1) / n4;
                int n10 = (rectangle.height + n3 - 1) / n3;
                Rectangle rectangle3 = new Rectangle(n8, n9, n2, n10);
                int n11 = sampleModel.getHeight();
                int n12 = sampleModel.getWidth();
                int[] nArray2 = sampleModel.getSampleSize();
                nArray = imageWriteParam.getSourceBands();
                boolean bl4 = true;
                n = sampleModel.getNumBands();
                if (nArray != null) {
                    sampleModel = sampleModel.createSubsetSampleModel(nArray);
                    colorModel = null;
                    bl4 = false;
                    n = sampleModel.getNumBands();
                } else {
                    nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = i;
                    }
                }
                byArray3 = null;
                byArray2 = null;
                byArray = null;
                bl2 = false;
                if (n == 1) {
                    if (colorModel instanceof IndexColorModel) {
                        object = (IndexColorModel)colorModel;
                        int n13 = ((IndexColorModel)object).getMapSize();
                        if (n13 < 1 << nArray2[0]) {
                            throw new RuntimeException(I18N.getString("PNMImageWrite2"));
                        }
                        if (nArray2[0] == 1) {
                            this.variant = 52;
                            bl2 = ((IndexColorModel)object).getRed(1) > ((IndexColorModel)object).getRed(0);
                        } else {
                            this.variant = 54;
                            byArray3 = new byte[n13];
                            byArray2 = new byte[n13];
                            byArray = new byte[n13];
                            ((IndexColorModel)object).getReds(byArray3);
                            ((IndexColorModel)object).getGreens(byArray2);
                            ((IndexColorModel)object).getBlues(byArray);
                        }
                    } else {
                        this.variant = nArray2[0] == 1 ? 52 : (nArray2[0] <= 8 ? 53 : 50);
                    }
                } else if (n == 3) {
                    this.variant = nArray2[0] <= 8 && nArray2[1] <= 8 && nArray2[2] <= 8 ? 54 : 51;
                } else {
                    throw new RuntimeException(I18N.getString("PNMImageWrite3"));
                }
                object = iIOImage.getMetadata();
                if (colorModel != null) {
                    imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
                } else {
                    int n14 = sampleModel.getDataType();
                    switch (n) {
                        case 1: {
                            imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(nArray2[0], n14, false);
                            break;
                        }
                        case 3: {
                            ColorSpace colorSpace = ColorSpace.getInstance(1000);
                            imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0, 1, 2}, n14, false, false);
                            break;
                        }
                        default: {
                            throw new IIOException("Cannot encode image with " + n + " bands!");
                        }
                    }
                }
                PNMMetadata pNMMetadata = object != null ? (PNMMetadata)this.convertImageMetadata((IIOMetadata)object, imageTypeSpecifier, imageWriteParam) : (PNMMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
                boolean bl5 = imageWriteParam instanceof PNMImageWriteParam ? ((PNMImageWriteParam)imageWriteParam).getRaw() : pNMMetadata.isRaw();
                this.maxValue = pNMMetadata.getMaxValue();
                for (n5 = 0; n5 < nArray2.length; ++n5) {
                    int n15 = (1 << nArray2[n5]) - 1;
                    if (n15 <= this.maxValue) continue;
                    this.maxValue = n15;
                }
                if (bl5) {
                    n5 = pNMMetadata.getMaxBitDepth();
                    if (!this.isRaw(this.variant) && n5 <= 8) {
                        this.variant += 3;
                    } else if (this.isRaw(this.variant) && n5 > 8) {
                        this.variant -= 3;
                    }
                } else if (this.isRaw(this.variant)) {
                    this.variant -= 3;
                }
                this.stream.writeByte(80);
                this.stream.writeByte(this.variant);
                this.stream.write(lineSeparator);
                this.stream.write(COMMENT.getBytes());
                Iterator iterator = pNMMetadata.getComments();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        this.stream.write(lineSeparator);
                        String string = "# " + (String)iterator.next();
                        this.stream.write(string.getBytes());
                    }
                }
                this.stream.write(lineSeparator);
                this.writeInteger(this.stream, n2);
                this.stream.write(32);
                this.writeInteger(this.stream, n10);
                if (this.variant != 52 && this.variant != 49) {
                    this.stream.write(lineSeparator);
                    this.writeInteger(this.stream, this.maxValue);
                }
                if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
                    this.stream.write(10);
                }
                bl = false;
                if (this.variant != 52 || sampleModel.getTransferType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel)) break block79;
                sampleModel2 = (MultiPixelPackedSampleModel)sampleModel;
                int n16 = 0;
                n16 = bl3 ? raster.getMinX() : renderedImage.getMinX();
                if (((MultiPixelPackedSampleModel)sampleModel2).getBitOffset((rectangle.x - n16) % n12) != 0 || ((MultiPixelPackedSampleModel)sampleModel2).getPixelBitStride() != 1 || n4 != 1) break block80;
                bl = true;
                break block80;
            }
            if ((this.variant == 53 || this.variant == 54) && sampleModel instanceof ComponentSampleModel && !(colorModel instanceof IndexColorModel) && ((ComponentSampleModel)(sampleModel2 = (ComponentSampleModel)sampleModel)).getPixelStride() == n && n4 == 1) {
                bl = true;
                if (this.variant == 54) {
                    int[] nArray3 = ((ComponentSampleModel)sampleModel2).getBandOffsets();
                    for (int i = 0; i < n; ++i) {
                        if (nArray3[i] == i) continue;
                        bl = false;
                        break;
                    }
                }
            }
        }
        if (bl) {
            int n17 = this.variant == 52 ? (n2 + 7) / 8 : n2 * sampleModel.getNumBands();
            byte[] byArray4 = null;
            byte[] byArray5 = new byte[n17];
            for (int i = 0; i < rectangle.height && !this.abortRequested(); ++i) {
                Raster raster2 = null;
                if (bl3) {
                    raster2 = raster.createChild(rectangle.x, i, rectangle.width, 1, 0, 0, null);
                } else {
                    raster2 = renderedImage.getData(new Rectangle(rectangle.x, rectangle.y + i, n2, 1));
                    raster2 = raster2.createTranslatedChild(0, 0);
                }
                byArray4 = ((DataBufferByte)raster2.getDataBuffer()).getData();
                sampleModel = raster2.getSampleModel();
                int n18 = 0;
                if (sampleModel instanceof ComponentSampleModel) {
                    n18 = ((ComponentSampleModel)sampleModel).getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinY() - raster2.getSampleModelTranslateY());
                } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
                    n18 = ((MultiPixelPackedSampleModel)sampleModel).getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinX() - raster2.getSampleModelTranslateY());
                }
                if (bl2) {
                    int n19 = n18;
                    for (int j = 0; j < n17; ++j) {
                        byArray5[j] = ~byArray4[n19];
                        ++n19;
                    }
                    byArray4 = byArray5;
                    n18 = 0;
                }
                this.stream.write(byArray4, n18, n17);
                this.processImageProgress(100.0f * (float)i / (float)rectangle.height);
            }
            this.stream.flush();
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
            }
            return;
        }
        int n20 = rectangle.width * n;
        int[] nArray4 = new int[n20];
        byte[] byArray6 = byArray3 == null ? new byte[n2 * n] : new byte[n2 * 3];
        int n21 = 0;
        int n22 = rectangle.y + rectangle.height;
        for (int i = rectangle.y; i < n22 && !this.abortRequested(); i += n3) {
            Raster raster3 = null;
            raster3 = bl3 ? raster.createChild(rectangle.x, i, rectangle.width, 1, rectangle.x, i, nArray) : renderedImage.getData(new Rectangle(rectangle.x, i, rectangle.width, 1));
            raster3.getPixels(rectangle.x, i, rectangle.width, 1, nArray4);
            if (bl2) {
                for (int j = 0; j < n20; j += n4) {
                    int n23 = j;
                    byArray6[n23] = (byte)(byArray6[n23] ^ 1);
                }
            }
            switch (this.variant) {
                case 49: 
                case 50: {
                    for (int j = 0; j < n20; j += n4) {
                        if (n21++ % 16 == 0) {
                            this.stream.write(lineSeparator);
                        } else {
                            this.stream.write(32);
                        }
                        this.writeInteger(this.stream, nArray4[j]);
                    }
                    this.stream.write(lineSeparator);
                    break;
                }
                case 51: {
                    int n24;
                    int n25;
                    if (byArray3 == null) {
                        int[] nArray5 = ((ComponentSampleModel)sampleModel).getBandOffsets();
                        for (n25 = 0; n25 < n20; n25 += n4 * n) {
                            for (n24 = 0; n24 < n; ++n24) {
                                if (n21++ % 16 == 0) {
                                    this.stream.write(lineSeparator);
                                } else {
                                    this.stream.write(32);
                                }
                                this.writeInteger(this.stream, nArray4[n25 + n24]);
                            }
                        }
                    } else {
                        for (int j = 0; j < n20; j += n4) {
                            if (n21++ % 5 == 0) {
                                this.stream.write(lineSeparator);
                            } else {
                                this.stream.write(32);
                            }
                            this.writeInteger(this.stream, byArray3[nArray4[j]] & 0xFF);
                            this.stream.write(32);
                            this.writeInteger(this.stream, byArray2[nArray4[j]] & 0xFF);
                            this.stream.write(32);
                            this.writeInteger(this.stream, byArray[nArray4[j]] & 0xFF);
                        }
                    }
                    this.stream.write(lineSeparator);
                    break;
                }
                case 52: {
                    int n26;
                    int n27 = 0;
                    int n25 = 0;
                    int n24 = 0;
                    int n28 = 7;
                    for (n26 = 0; n26 < n20; n26 += n4) {
                        n24 |= nArray4[n26] << n28;
                        if (--n28 != -1) continue;
                        byArray6[n27++] = (byte)n24;
                        n24 = 0;
                        n28 = 7;
                    }
                    if (n28 != 7) {
                        byArray6[n27++] = (byte)n24;
                    }
                    this.stream.write(byArray6, 0, n27);
                    break;
                }
                case 53: {
                    int n26;
                    int n29 = 0;
                    for (n26 = 0; n26 < n20; n26 += n4) {
                        byArray6[n29++] = (byte)nArray4[n26];
                    }
                    this.stream.write(byArray6, 0, n2);
                    break;
                }
                case 54: {
                    int n29;
                    int n26;
                    if (byArray3 == null) {
                        n29 = 0;
                        for (n26 = 0; n26 < n20; n26 += n4 * n) {
                            for (int j = 0; j < n; ++j) {
                                byArray6[n29++] = (byte)(nArray4[n26 + j] & 0xFF);
                            }
                        }
                    } else {
                        n29 = 0;
                        for (n26 = 0; n26 < n20; n26 += n4) {
                            byArray6[n29++] = byArray3[nArray4[n26]];
                            byArray6[n29++] = byArray2[nArray4[n26]];
                            byArray6[n29++] = byArray[nArray4[n26]];
                        }
                    }
                    this.stream.write(byArray6, 0, byArray6.length);
                }
            }
            this.processImageProgress(100.0f * (float)(i - rectangle.y) / (float)rectangle.height);
        }
        this.stream.flush();
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private void writeInteger(ImageOutputStream imageOutputStream, int n) throws IOException {
        imageOutputStream.write(Integer.toString(n).getBytes());
    }

    private void writeByte(ImageOutputStream imageOutputStream, byte by) throws IOException {
        imageOutputStream.write(Byte.toString(by).getBytes());
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }

    static {
        if (lineSeparator == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            lineSeparator = string.getBytes();
        }
    }
}

