/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.parser.JsonLocationImpl;
import oracle.sql.json.OracleJsonParser;

final class JsonTokenizer
implements Closeable {
    private static final int[] HEX;
    private static final int HEX_LENGTH;
    private final BufferPoolImpl bufferPool;
    private final Reader reader;
    private char[] buf;
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private long lineNo = 1L;
    private long lastLineOffset = 0L;
    private long bufferOffset = 0L;
    private boolean minus;
    private boolean fracOrExp;
    private BigDecimal bd;

    JsonTokenizer(Reader reader, BufferPoolImpl bufferPoolImpl) {
        this.reader = reader;
        this.bufferPool = bufferPoolImpl;
        this.buf = bufferPoolImpl.take();
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    private void readString() {
        int n2;
        boolean bl = true;
        this.storeBegin = this.storeEnd = this.readBegin;
        block4: while (true) {
            if (bl) {
                while (this.readBegin < this.readEnd && (n2 = this.buf[this.readBegin]) >= 32 && n2 != 92) {
                    if (n2 == 34) {
                        this.storeEnd = this.readBegin++;
                        return;
                    }
                    ++this.readBegin;
                }
                this.storeEnd = this.readBegin;
            }
            if ((n2 = this.read()) >= 32 && n2 != 34 && n2 != 92) {
                if (!bl) {
                    this.buf[this.storeEnd] = (char)n2;
                }
                ++this.storeEnd;
                continue;
            }
            switch (n2) {
                case 92: {
                    bl = false;
                    this.unescape();
                    continue block4;
                }
                case 34: {
                    return;
                }
            }
            break;
        }
        throw this.unexpectedChar(n2);
    }

    private void unescape() {
        int n2 = this.read();
        switch (n2) {
            case 98: {
                this.buf[this.storeEnd++] = 8;
                break;
            }
            case 116: {
                this.buf[this.storeEnd++] = 9;
                break;
            }
            case 110: {
                this.buf[this.storeEnd++] = 10;
                break;
            }
            case 102: {
                this.buf[this.storeEnd++] = 12;
                break;
            }
            case 114: {
                this.buf[this.storeEnd++] = 13;
                break;
            }
            case 34: 
            case 47: 
            case 92: {
                this.buf[this.storeEnd++] = (char)n2;
                break;
            }
            case 117: {
                int n3 = 0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    int n4;
                    int n5 = this.read();
                    int n6 = n4 = n5 >= 0 && n5 < HEX_LENGTH ? HEX[n5] : -1;
                    if (n4 < 0) {
                        throw this.unexpectedChar(n5);
                    }
                    n3 = n3 << 4 | n4;
                }
                this.buf[this.storeEnd++] = (char)n3;
                break;
            }
            default: {
                throw this.unexpectedChar(n2);
            }
        }
    }

    private int readNumberChar() {
        if (this.readBegin < this.readEnd) {
            return this.buf[this.readBegin++];
        }
        this.storeEnd = this.readBegin;
        return this.read();
    }

    private void readNumber(int n2) {
        int n3;
        this.storeBegin = this.storeEnd = this.readBegin - 1;
        if (n2 == 45) {
            this.minus = true;
            n2 = this.readNumberChar();
            if (n2 < 48 || n2 > 57) {
                throw this.unexpectedChar(n2);
            }
        }
        if (n2 == 48) {
            n2 = this.readNumberChar();
        } else {
            while ((n2 = this.readNumberChar()) >= 48 && n2 <= 57) {
            }
        }
        if (n2 == 46) {
            this.fracOrExp = true;
            n3 = 0;
            do {
                n2 = this.readNumberChar();
                ++n3;
            } while (n2 >= 48 && n2 <= 57);
            if (n3 == 1) {
                throw this.unexpectedChar(n2);
            }
        }
        if (n2 == 101 || n2 == 69) {
            this.fracOrExp = true;
            n2 = this.readNumberChar();
            if (n2 == 43 || n2 == 45) {
                n2 = this.readNumberChar();
            }
            n3 = 0;
            while (n2 >= 48 && n2 <= 57) {
                n2 = this.readNumberChar();
                ++n3;
            }
            if (n3 == 0) {
                throw this.unexpectedChar(n2);
            }
        }
        if (n2 != -1) {
            --this.readBegin;
            this.storeEnd = this.readBegin;
        }
    }

    private void readTrue() {
        int n2 = this.read();
        if (n2 != 114) {
            throw this.expectedChar(n2, 'r');
        }
        int n3 = this.read();
        if (n3 != 117) {
            throw this.expectedChar(n3, 'u');
        }
        int n4 = this.read();
        if (n4 != 101) {
            throw this.expectedChar(n4, 'e');
        }
    }

    private void readFalse() {
        int n2 = this.read();
        if (n2 != 97) {
            throw this.expectedChar(n2, 'a');
        }
        int n3 = this.read();
        if (n3 != 108) {
            throw this.expectedChar(n3, 'l');
        }
        int n4 = this.read();
        if (n4 != 115) {
            throw this.expectedChar(n4, 's');
        }
        int n5 = this.read();
        if (n5 != 101) {
            throw this.expectedChar(n5, 'e');
        }
    }

    private void readNull() {
        int n2 = this.read();
        if (n2 != 117) {
            throw this.expectedChar(n2, 'u');
        }
        int n3 = this.read();
        if (n3 != 108) {
            throw this.expectedChar(n3, 'l');
        }
        int n4 = this.read();
        if (n4 != 108) {
            throw this.expectedChar(n4, 'l');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    JsonToken nextToken() {
        this.reset();
        int n2 = this.read();
        while (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13) {
            block19: {
                if (n2 == 13) {
                    ++this.lineNo;
                    n2 = this.read();
                    if (n2 == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        break block19;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin - 1L;
                        continue;
                    }
                }
                if (n2 == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                }
            }
            n2 = this.read();
        }
        switch (n2) {
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber(n2);
                return JsonToken.NUMBER;
            }
            case -1: {
                return JsonToken.EOF;
            }
        }
        throw this.unexpectedChar(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasNextToken() {
        this.reset();
        int n2 = this.peek();
        while (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13) {
            block5: {
                if (n2 == 13) {
                    ++this.lineNo;
                    ++this.readBegin;
                    n2 = this.peek();
                    if (n2 == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
                        break block5;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        continue;
                    }
                }
                if (n2 == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
                }
            }
            ++this.readBegin;
            n2 = this.peek();
        }
        if (n2 == -1) return false;
        return true;
    }

    private int peek() {
        try {
            if (this.readBegin == this.readEnd) {
                int n2 = this.fillBuf();
                if (n2 == -1) {
                    return -1;
                }
                assert (n2 != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n2;
            }
            return this.buf[this.readBegin];
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), iOException, new Object[0]);
        }
    }

    JsonLocationImpl getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset, this.bufferOffset + (long)this.readBegin - 1L);
    }

    JsonLocationImpl getLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset + 1L, this.bufferOffset + (long)this.readBegin);
    }

    private int read() {
        try {
            if (this.readBegin == this.readEnd) {
                int n2 = this.fillBuf();
                if (n2 == -1) {
                    return -1;
                }
                assert (n2 != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n2;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), iOException, new Object[0]);
        }
    }

    private int fillBuf() throws IOException {
        if (this.storeEnd != 0) {
            int n2 = this.storeEnd - this.storeBegin;
            if (n2 > 0) {
                if (n2 == this.buf.length) {
                    char[] cArray = Arrays.copyOf(this.buf, 2 * this.buf.length);
                    this.bufferPool.recycle(this.buf);
                    this.buf = cArray;
                } else {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, n2);
                    this.storeEnd = n2;
                    this.storeBegin = 0;
                    this.bufferOffset += (long)(this.readBegin - this.storeEnd);
                }
            } else {
                this.storeEnd = 0;
                this.storeBegin = 0;
                this.bufferOffset += (long)this.readBegin;
            }
        } else {
            this.bufferOffset += (long)this.readBegin;
        }
        return this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
    }

    private void reset() {
        if (this.storeEnd != 0) {
            this.storeBegin = 0;
            this.storeEnd = 0;
            this.bd = null;
            this.minus = false;
            this.fracOrExp = false;
        }
    }

    String getValue() {
        return new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
    }

    BigDecimal getBigDecimal() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int getInt() {
        int n2 = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (n2 <= 9 || this.minus && n2 <= 10)) {
            int n3;
            int n4 = 0;
            int n5 = n3 = this.minus ? 1 : 0;
            while (n3 < n2) {
                n4 = n4 * 10 + (this.buf[this.storeBegin + n3] - 48);
                ++n3;
            }
            return this.minus ? -n4 : n4;
        }
        return this.getBigDecimal().intValue();
    }

    long getLong() {
        int n2 = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (n2 <= 18 || this.minus && n2 <= 19)) {
            int n3;
            long l2 = 0L;
            int n4 = n3 = this.minus ? 1 : 0;
            while (n3 < n2) {
                l2 = l2 * 10L + (long)(this.buf[this.storeBegin + n3] - 48);
                ++n3;
            }
            return this.minus ? -l2 : l2;
        }
        return this.getBigDecimal().longValue();
    }

    boolean isDefinitelyInt() {
        int n2 = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (n2 <= 9 || this.minus && n2 <= 10);
    }

    boolean isDefinitelyLong() {
        int n2 = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (n2 <= 18 || this.minus && n2 <= 19);
    }

    boolean isIntegral() {
        return !this.fracOrExp || this.getBigDecimal().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.bufferPool.recycle(this.buf);
    }

    private RuntimeException unexpectedChar(int n2) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return OracleJsonExceptions.TOKEN_UNEXPECTED_CHAR.create(this.factory(), this.chToString(n2), jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber());
    }

    private RuntimeException expectedChar(int n2, char c2) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return OracleJsonExceptions.TOKEN_EXPECTED_CHAR.create(this.factory(), this.chToString(n2), jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber(), this.chToString(c2));
    }

    private String chToString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 >= 32 && n2 <= 126) {
            stringBuilder.append("'");
            stringBuilder.appendCodePoint(n2);
            stringBuilder.append("'");
        } else {
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toHexString(n2));
        }
        return stringBuilder.toString();
    }

    static {
        int n2;
        HEX = new int[128];
        Arrays.fill(HEX, -1);
        for (n2 = 48; n2 <= 57; ++n2) {
            JsonTokenizer.HEX[n2] = n2 - 48;
        }
        for (n2 = 65; n2 <= 70; ++n2) {
            JsonTokenizer.HEX[n2] = 10 + n2 - 65;
        }
        for (n2 = 97; n2 <= 102; ++n2) {
            JsonTokenizer.HEX[n2] = 10 + n2 - 97;
        }
        HEX_LENGTH = HEX.length;
    }

    static enum JsonToken {
        CURLYOPEN(OracleJsonParser.Event.START_OBJECT, false),
        SQUAREOPEN(OracleJsonParser.Event.START_ARRAY, false),
        COLON(null, false),
        COMMA(null, false),
        STRING(OracleJsonParser.Event.VALUE_STRING, true),
        NUMBER(OracleJsonParser.Event.VALUE_DECIMAL, true),
        TRUE(OracleJsonParser.Event.VALUE_TRUE, true),
        FALSE(OracleJsonParser.Event.VALUE_FALSE, true),
        NULL(OracleJsonParser.Event.VALUE_NULL, true),
        CURLYCLOSE(OracleJsonParser.Event.END_OBJECT, false),
        SQUARECLOSE(OracleJsonParser.Event.END_ARRAY, false),
        EOF(null, false);

        private final OracleJsonParser.Event event;
        private final boolean value;

        private JsonToken(OracleJsonParser.Event event, boolean bl) {
            this.event = event;
            this.value = bl;
        }

        OracleJsonParser.Event getEvent() {
            return this.event;
        }

        boolean isValue() {
            return this.value;
        }
    }
}

