/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.color.ColorSpace;

public final class InvertedCMYKColorSpace
extends ColorSpace {
    private static ColorSpace theInstance = null;
    private ColorSpace csRGB = ColorSpace.getInstance(1004);
    private static final double power1 = 0.4166666666666667;

    public static final synchronized ColorSpace getInstance() {
        if (theInstance == null) {
            theInstance = new InvertedCMYKColorSpace();
        }
        return theInstance;
    }

    private InvertedCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof InvertedCMYKColorSpace;
    }

    public float[] toRGB(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float[] fArray2 = new float[]{f4 * f, f4 * f2, f4 * f3};
        for (int i = 0; i < 3; ++i) {
            float f5 = fArray2[i];
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 < 0.0031308f) {
                fArray2[i] = 12.92f * f5;
                continue;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            fArray2[i] = (float)(1.055 * Math.pow(f5, 0.4166666666666667) - 0.055);
        }
        return fArray2;
    }

    public float[] fromRGB(float[] fArray) {
        for (int i = 0; i < 3; ++i) {
            if (fArray[i] < 0.040449936f) {
                int n = i;
                fArray[n] = fArray[n] / 12.92f;
                continue;
            }
            fArray[i] = (float)Math.pow(((double)fArray[i] + 0.055) / 1.055, 2.4);
        }
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = Math.max(f, Math.max(f2, f3));
        if (f4 != 0.0f) {
            f /= f4;
            f2 /= f4;
            f3 /= f4;
        } else {
            f3 = 1.0f;
            f2 = 1.0f;
            f = 1.0f;
        }
        return new float[]{f, f2, f3, f4};
    }

    public float[] toCIEXYZ(float[] fArray) {
        return this.csRGB.toCIEXYZ(this.toRGB(fArray));
    }

    public float[] fromCIEXYZ(float[] fArray) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(fArray));
    }
}

