/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.common.LZWCompressor;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class TIFFLZWCompressor
extends TIFFCompressor {
    int predictor;

    public TIFFLZWCompressor(int n) {
        super("LZW", 5, true);
        this.predictor = n;
    }

    public void setStream(ImageOutputStream imageOutputStream) {
        super.setStream(imageOutputStream);
    }

    public int encode(byte[] byArray, int n, int n2, int n3, int[] nArray, int n4) throws IOException {
        boolean bl;
        int n5;
        LZWCompressor lZWCompressor = new LZWCompressor(this.stream, 8, true);
        int n6 = nArray.length;
        int n7 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            n7 += nArray[n5];
        }
        n5 = (n7 * n2 + 7) / 8;
        long l = this.stream.getStreamPosition();
        boolean bl2 = bl = this.predictor == 2;
        if (n5 == n4 && !bl) {
            lZWCompressor.compress(byArray, n, n5 * n3);
        } else {
            byte[] byArray2 = bl ? new byte[n5] : null;
            for (int i = 0; i < n3; ++i) {
                if (bl) {
                    System.arraycopy(byArray, n, byArray2, 0, n5);
                    for (int j = n5 - 1; j >= n6; --j) {
                        int n8 = j;
                        byArray2[n8] = (byte)(byArray2[n8] - byArray2[j - n6]);
                    }
                    lZWCompressor.compress(byArray2, 0, n5);
                } else {
                    lZWCompressor.compress(byArray, n, n5);
                }
                n += n4;
            }
        }
        lZWCompressor.flush();
        int n9 = (int)(this.stream.getStreamPosition() - l);
        return n9;
    }
}

