/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFLZWUtil {
    private static final boolean debug = false;
    byte[] srcData;
    int srcIndex;
    byte[] dstData;
    int dstIndex = 0;
    byte[][] stringTable;
    int tableIndex;
    int bitsToGet = 9;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    private static final int[] andTable = new int[]{511, 1023, 2047, 4095};

    public byte[] decode(byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        int n5;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new IIOException("TIFF 5.0-style LZW compression is not supported!");
        }
        this.srcData = byArray;
        this.srcIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        this.dstData = new byte[8192];
        this.dstIndex = 0;
        this.initializeStringTable();
        int n6 = 0;
        while ((n5 = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n5 == 256) {
                this.initializeStringTable();
                n5 = this.getNextCode();
                if (n5 == 257) break;
                this.writeString(this.stringTable[n5]);
                n6 = n5;
                continue;
            }
            if (n5 < this.tableIndex) {
                byArray2 = this.stringTable[n5];
                this.writeString(byArray2);
                this.addStringToTable(this.stringTable[n6], byArray2[0]);
                n6 = n5;
                continue;
            }
            byArray2 = this.stringTable[n6];
            byArray2 = this.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n6 = n5;
        }
        if (n == 2) {
            for (int i = 0; i < n4; ++i) {
                int n7 = n2 * (i * n3 + 1);
                for (int j = n2; j < n3 * n2; ++j) {
                    int n8 = n7;
                    this.dstData[n8] = (byte)(this.dstData[n8] + this.dstData[n7 - n2]);
                    ++n7;
                }
            }
        }
        byte[] byArray3 = new byte[this.dstIndex];
        System.arraycopy(this.dstData, 0, byArray3, 0, this.dstIndex);
        return byArray3;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    private void ensureCapacity(int n) {
        if (this.dstIndex + n > this.dstData.length) {
            byte[] byArray = new byte[Math.max((int)((float)this.dstData.length * 1.2f), this.dstIndex + n)];
            System.arraycopy(this.dstData, 0, byArray, 0, this.dstData.length);
            this.dstData = byArray;
        }
    }

    public void writeString(byte[] byArray) {
        this.ensureCapacity(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.dstData[this.dstIndex++] = byArray[i];
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
                this.nextBits += 8;
            }
            int n = this.nextData >> this.nextBits - this.bitsToGet & andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

