/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;

public class FileCodestreamWriter
extends CodestreamWriter
implements Markers {
    private static final int SOP_MARKER_LIMIT = 65535;
    private int tileIdx = 0;
    private OutputStream out;
    int ndata = 0;
    public static int DEF_BUF_LEN = 1024;
    byte[] sopMarker;
    byte[] ephMarker;
    int packetIdx = 0;
    private int offLastROIPkt = 0;
    private int lenLastNoROI = 0;

    public FileCodestreamWriter(File file, int n) throws IOException {
        super(n);
        this.out = new BufferedOutputStream(new FileOutputStream(file), DEF_BUF_LEN);
        this.initSOP_EPHArrays();
    }

    public FileCodestreamWriter(String string, int n) throws IOException {
        super(n);
        this.out = new BufferedOutputStream(new FileOutputStream(string), DEF_BUF_LEN);
        this.initSOP_EPHArrays();
    }

    public FileCodestreamWriter(OutputStream outputStream, int n) throws IOException {
        super(n);
        this.out = outputStream;
        this.initSOP_EPHArrays();
    }

    public final int getMaxAvailableBytes() {
        return this.maxBytes - this.ndata;
    }

    public int getLength() {
        if (this.getMaxAvailableBytes() >= 0) {
            return this.ndata;
        }
        return this.maxBytes;
    }

    public int writePacketHead(byte[] byArray, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n2 = n + (bl2 ? 6 : 0) + (bl3 ? 2 : 0);
        if (!bl) {
            if (this.getMaxAvailableBytes() < n2) {
                n2 = this.getMaxAvailableBytes();
            }
            if (n2 > 0) {
                if (bl2) {
                    this.sopMarker[4] = (byte)(this.packetIdx >> 8);
                    this.sopMarker[5] = (byte)this.packetIdx;
                    this.out.write(this.sopMarker, 0, 6);
                    ++this.packetIdx;
                    if (this.packetIdx > 65535) {
                        this.packetIdx = 0;
                    }
                }
                this.out.write(byArray, 0, n);
                this.ndata += n2;
                if (bl3) {
                    this.out.write(this.ephMarker, 0, 2);
                }
                this.lenLastNoROI += n2;
            }
        }
        return n2;
    }

    public int writePacketBody(byte[] byArray, int n, boolean bl, boolean bl2, int n2) throws IOException {
        int n3 = n;
        if (!bl) {
            n3 = n;
            if (this.getMaxAvailableBytes() < n3) {
                n3 = this.getMaxAvailableBytes();
            }
            if (n > 0) {
                this.out.write(byArray, 0, n3);
            }
            this.ndata += n3;
            if (bl2) {
                this.offLastROIPkt += this.lenLastNoROI + n2;
                this.lenLastNoROI = n3 - n2;
            } else {
                this.lenLastNoROI += n3;
            }
        }
        return n3;
    }

    public void close() throws IOException {
        this.out.write(-1);
        this.out.write(-39);
        this.ndata += 2;
        this.out.close();
    }

    public int getOffLastROIPkt() {
        return this.offLastROIPkt;
    }

    public void commitBitstreamHeader(HeaderEncoder headerEncoder) throws IOException {
        this.ndata += headerEncoder.getLength();
        headerEncoder.writeTo(this.out);
        this.packetIdx = 0;
        this.lenLastNoROI += headerEncoder.getLength();
    }

    private void initSOP_EPHArrays() {
        this.sopMarker = new byte[6];
        this.sopMarker[0] = -1;
        this.sopMarker[1] = -111;
        this.sopMarker[2] = 0;
        this.sopMarker[3] = 4;
        this.ephMarker = new byte[2];
        this.ephMarker[0] = -1;
        this.ephMarker[1] = -110;
    }
}

