/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSFactory;

public final class GDSType
implements Serializable {
    private static final Map<String, GDSType> typeMap = new HashMap<String, GDSType>();
    private static final GDSFactory factory = new GDSFactory();
    private final String name;

    public static GDSType getType(String type) {
        if (type == null) {
            return null;
        }
        return typeMap.get(type.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GDSType registerType(String typeName) {
        Map<String, GDSType> map = typeMap;
        synchronized (map) {
            if (typeMap.containsKey(typeName)) {
                return typeMap.get(typeName);
            }
            GDSType type = new GDSType(typeName);
            typeMap.put(typeName, type);
            return type;
        }
    }

    private GDSType(String s) {
        this.name = s;
    }

    public Object readResolve() {
        return GDSType.registerType(this.name);
    }

    public String toString() {
        return this.name;
    }
}

