/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XCalculatable;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.view.PrintJobEvent;
import com.sun.star.view.PrintableState;
import com.sun.star.view.XPrintJobBroadcaster;
import com.sun.star.view.XPrintJobListener;
import com.sun.star.view.XPrintable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.ProcessFactory;
import org.opengion.hayabusa.report2.SOfficeProcess;

public class DocConverter_OOO {
    private final boolean isOnline;
    private final String[] mergeFile;
    private String inputName;
    private String origName;
    private XComponent xComp;
    private SOfficeProcess soffice;
    private static final Map<String, String> FILTER_MAP = new HashMap<String, String>();

    public DocConverter_OOO(String string) {
        this(StringUtil.csv2Array((String)string), true);
    }

    public DocConverter_OOO(String[] stringArray) {
        this(stringArray, true);
    }

    public DocConverter_OOO(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0].isEmpty()) {
            throw new HybsSystemException("\u5165\u529b\uff8c\uff67\uff72\uff99\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61");
        }
        this.origName = stringArray[0];
        File file = new File(this.origName);
        if (!file.exists()) {
            throw new HybsSystemException("\u5165\u529b\uff8c\uff67\uff72\uff99\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\uff61[file=" + stringArray[0] + "]");
        }
        this.isOnline = bl;
        this.inputName = this.origName;
        if (stringArray.length == 1) {
            this.mergeFile = null;
        } else {
            if (!"xls".equals(DocConverter_OOO.getSuffix(this.origName)) && !"ods".equals(DocConverter_OOO.getSuffix(this.origName))) {
                throw new HybsSystemException("\uff8c\uff67\uff72\uff99\u306e\uff8f\uff70\uff7c\uff9e\u3092\u884c\u3046\u5834\u5408\uff64\u5165\u529b\uff8c\uff67\uff72\uff99\u306f\uff64Excel\u307e\u305f\u306fCacl\u5f62\u5f0f\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\uff61");
            }
            this.mergeFile = new String[stringArray.length - 1];
            for (int i = 0; i < this.mergeFile.length; ++i) {
                String string = stringArray[i + 1];
                if (string.isEmpty() || !new File(string).exists()) {
                    throw new HybsSystemException("\uff8f\uff70\uff7c\uff9e\uff8c\uff67\uff72\uff99\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u304b\uff64\u307e\u305f\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\uff61[file=" + string + "]");
                }
                if (this.inputName.equals(string)) {
                    throw new HybsSystemException("\uff8f\uff70\uff7c\uff9e\uff8c\uff67\uff72\uff99\u306b\u5165\u529b\uff8c\uff67\uff72\uff99\u3068\u540c\u3058\uff8c\uff67\uff72\uff99\u304c\u6307\u5b9a\u3055\u308c\u3066\u307e\u3059\uff61[file=" + string + "]");
                }
                if (!"xls".equals(DocConverter_OOO.getSuffix(string)) && !"ods".equals(DocConverter_OOO.getSuffix(string))) {
                    throw new HybsSystemException("\uff8c\uff67\uff72\uff99\u306e\uff8f\uff70\uff7c\uff9e\u3092\u884c\u3046\u5834\u5408\uff64\uff8f\uff70\uff7c\uff9e\uff8c\uff67\uff72\uff99\u306f\uff64Excel\u307e\u305f\u306fCacl\u5f62\u5f0f\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\uff61");
                }
                this.mergeFile[i] = string;
            }
        }
    }

    public void open() throws Throwable {
        if (this.soffice == null) {
            if (this.isOnline) {
                this.soffice = ProcessFactory.newInstance();
            } else {
                this.soffice = new SOfficeProcess("docconverter.class");
                this.soffice.bootstrap();
            }
            if (this.mergeFile != null) {
                File file = new File(this.origName);
                this.inputName = this.soffice.getTempPath() + System.currentTimeMillis() + "_" + file.getName();
                FileUtil.copy((File)file, (File)new File(this.inputName));
            }
        }
        this.xComp = this.getComponent(this.inputName, this.mergeFile == null, false);
        if (this.mergeFile != null) {
            for (int i = 0; i < this.mergeFile.length; ++i) {
                this.merge(this.mergeFile[i]);
            }
        }
    }

    private XComponent getComponent(String string, boolean bl, boolean bl2) {
        Object object;
        XComponent xComponent;
        PropertyValue[] propertyValueArray = new PropertyValue[2];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "Hidden";
        propertyValueArray[0].Value = bl;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "AsTemplate";
        propertyValueArray[1].Value = bl2;
        String string2 = "file:///" + string.replace('\\', '/');
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.soffice.getDesktop());
        try {
            xComponent = xComponentLoader.loadComponentFromURL(string2, "_blank", 0, propertyValueArray);
            object = (XCalculatable)UnoRuntime.queryInterface(XCalculatable.class, (Object)xComponent);
            object.calculateAll();
        }
        catch (IOException iOException) {
            throw new HybsSystemException("OpenOffice\u306e\u7acb\u3061\u4e0a\u3052\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\u5165\u51fa\u529b\uff74\uff97\uff70)\uff61", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("OpenOffice\u306e\u7acb\u3061\u4e0a\u3052\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f(\uff8a\uff9f\uff97\uff92\uff70\uff80\uff70\u4e0d\u6b63)\uff61", illegalArgumentException);
        }
        if (xComponent == null) {
            object = "OpenOffice[" + string + "]\uff8c\uff67\uff72\uff99\u304c\u4e0d\u6b63\u3067\u3059\uff61" + HybsConst.CR + "\u5370\u5237\u7bc4\u56f2\u8a2d\u5b9a\u3084\u3001\uff83\uff9e\uff70\uff80\u306bCTRL\u6587\u5b57\u7b49\u304c\u542b\u307e\u308c\u3066\u3044\u306a\u3044\u304b\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\uff61";
            throw new HybsSystemException((String)object);
        }
        return xComponent;
    }

    private void merge(String string) {
        XComponent xComponent = this.getComponent(string, false, true);
        XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)((XController)UnoRuntime.queryInterface(XController.class, (Object)((XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent)).getCurrentController())).getFrame());
        XDispatchHelper xDispatchHelper = this.soffice.getDispatcher();
        xDispatchHelper.executeDispatch(xDispatchProvider, ".uno:TableSelectAll", "", 0, new PropertyValue[0]);
        String string2 = new File(this.inputName).getName();
        string2 = string2.substring(0, string2.indexOf(46));
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "DocName";
        propertyValueArray[0].Value = string2;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Index";
        propertyValueArray[1].Value = Short.MAX_VALUE;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Copy";
        propertyValueArray[2].Value = true;
        xDispatchHelper.executeDispatch(xDispatchProvider, ".uno:Move", "", 0, propertyValueArray);
        this.closeComponent(xComponent);
    }

    public void close() throws Throwable {
        this.close(false);
    }

    public void close(boolean bl) {
        if (this.xComp != null) {
            this.closeComponent(this.xComp);
        }
        if (this.soffice != null) {
            if (this.isOnline) {
                if (bl) {
                    ProcessFactory.remove(this.soffice);
                } else {
                    ProcessFactory.release(this.soffice);
                }
            } else {
                this.soffice.close();
            }
        }
        if (this.mergeFile != null && !new File(this.inputName).delete()) {
            System.err.println("\uff83\uff9d\uff8e\uff9f\uff97\uff98\u306b\uff7a\uff8b\uff9f\uff70\u3057\u305f\uff8c\uff67\uff72\uff99\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61[" + this.inputName + "]");
        }
    }

    private void closeComponent(XComponent xComponent) {
        XCloseable xCloseable = null;
        int n = 0;
        while (true) {
            try {
                xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xComponent);
                xCloseable.close(true);
            }
            catch (CloseVetoException closeVetoException) {
                if (n == 600) {
                    throw new HybsSystemException("soffice\uff8c\uff9f\uff9b\uff7e\uff7d\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\uff61", closeVetoException);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public void print(String string) throws Throwable {
        if (string == null || string.isEmpty()) {
            throw new HybsSystemException("\uff8c\uff9f\uff98\uff9d\uff80\uff70\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61");
        }
        XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.xComp);
        XPrintJobBroadcaster xPrintJobBroadcaster = (XPrintJobBroadcaster)UnoRuntime.queryInterface(XPrintJobBroadcaster.class, (Object)xPrintable);
        MyPrintJobListener myPrintJobListener = new MyPrintJobListener();
        xPrintJobBroadcaster.addPrintJobListener((XPrintJobListener)myPrintJobListener);
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Name";
        propertyValueArray[0].Value = "LINUX".indexOf(HybsSystem.sys("OS_INFO").toUpperCase(Locale.JAPAN)) >= 0 ? "<" + string + ">" : string;
        try {
            xPrintable.setPrinter(propertyValueArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61", illegalArgumentException);
        }
        String string2 = null;
        for (PropertyValue propertyValue : xPrintable.getPrinter()) {
            if (!"Name".equals(propertyValue.Name)) continue;
            string2 = (String)propertyValue.Value;
            break;
        }
        if (!string.equalsIgnoreCase(string2)) {
            String string3 = "\uff8c\uff9f\uff98\uff9d\uff80\uff70[" + string + "]\u3092\u767a\u884c\u5148\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61" + HybsConst.CR + "\u5b58\u5728\u3057\u306a\u3044\uff8c\uff9f\uff98\uff9d\uff80\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\uff61";
            throw new HybsSystemException(string3);
        }
        PropertyValue[] propertyValueArray2 = new PropertyValue[]{new PropertyValue()};
        propertyValueArray2[0].Name = "Wait";
        propertyValueArray2[0].Value = true;
        try {
            xPrintable.print(propertyValueArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HybsSystemException("\u5370\u5237\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61", illegalArgumentException);
        }
        if (myPrintJobListener.isError()) {
            throw new HybsSystemException("Error Occured while spooling print job. Check Spooler-Service!!!");
        }
    }

    public void pdf(String string, String string2) throws Throwable {
        if (!this.checkOutput(string)) {
            return;
        }
        this.savePdf(string, DocConverter_OOO.getFilterName(this.inputName, "pdf"), string2);
    }

    public void auto(String string) throws Throwable {
        if (!this.checkOutput(string)) {
            return;
        }
        String string2 = DocConverter_OOO.getSuffix(string);
        if ("pdf".equalsIgnoreCase(string2)) {
            this.savePdf(string, DocConverter_OOO.getFilterName(this.inputName, string2), null);
        } else {
            this.saveDoc(string, DocConverter_OOO.getFilterName(this.inputName, string2));
        }
    }

    private void saveDoc(String string, String string2) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "FilterName";
        propertyValueArray[0].Value = string2;
        String string3 = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xComp);
        try {
            xStorable.storeAsURL(string3, propertyValueArray);
        }
        catch (Throwable throwable) {
            throw new HybsSystemException("\uff8c\uff67\uff72\uff99\u3078\u306e\u5909\u63db\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61[filter=" + string2 + "]", throwable);
        }
    }

    private void savePdf(String string, String string2, String string3) {
        Object object;
        PropertyValue[] propertyValueArray;
        if (string3 == null || string3.isEmpty()) {
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = string2;
        } else {
            object = new PropertyValue[2];
            object[0] = new PropertyValue();
            object[0].Name = "EncryptFile";
            object[0].Value = true;
            object[1] = new PropertyValue();
            object[1].Name = "DocumentOpenPassword";
            object[1].Value = string3;
            propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = "calc_pdf_Export";
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "FilterData";
            propertyValueArray[1].Value = object;
        }
        object = "file:///" + string.replace('\\', '/');
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xComp);
        try {
            xStorable.storeToURL((String)object, propertyValueArray);
        }
        catch (Throwable throwable) {
            String string4 = "PDF\uff8c\uff67\uff72\uff99\u3078\u306e\u5909\u63db\u6642\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61[filter=" + string2 + "] URL=" + (String)object + " , storeProps=" + propertyValueArray + " , xComp=" + this.xComp;
            throw new HybsSystemException(string4, throwable);
        }
    }

    private boolean checkOutput(String string) {
        if (string == null || string.isEmpty()) {
            throw new HybsSystemException("\u51fa\u529b\uff8c\uff67\uff72\uff99\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61");
        }
        try {
            Path path = Paths.get(string, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            if (DocConverter_OOO.getSuffix(this.inputName).equals(DocConverter_OOO.getSuffix(string))) {
                Path path2 = Paths.get(this.inputName, new String[0]);
                Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
                return false;
            }
        }
        catch (Throwable throwable) {
            throw new HybsSystemException("\uff8c\uff67\uff72\uff99\uff7a\uff8b\uff9f\uff70\u304c\u5931\u6557\u3057\u307e\u3057\u305f\uff61[in=" + this.inputName + "],out=" + string + "]", throwable);
        }
        return true;
    }

    private static String getFilterName(String string, String string2) {
        String string3 = DocConverter_OOO.getSuffix(string);
        String string4 = FILTER_MAP.get(string3 + "_" + string2);
        if (string4 == null) {
            String string5 = "\u5165\u529b\uff8c\uff67\uff72\uff99=[" + string + "] , \u51fa\u529b\u5f62\u5f0f=[" + string2 + "]" + HybsConst.CR + "\u5165\u529b\u5f62\u5f0f\uff64\u51fa\u529b\u5f62\u5f0f\u306f\uff64\u4ee5\u4e0b\u306e\u5bfe\u5fdc\u8868\u306b\u57fa\u3065\u304d\uff64\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\uff61" + HybsConst.CR + "\u5165\u529b[Calc(ods)   ,Excel(xls)     ] \u21d2 \u51fa\u529b[Calc(ods)   ,Excel(xls,xlsx)     ,PDF]" + HybsConst.CR + "\u5165\u529b[Writer(odt) ,Word(doc)      ] \u21d2 \u51fa\u529b[Writer(odt) ,Word(doc,docx)      ,PDF]" + HybsConst.CR + "\u5165\u529b[Impress(odp),PowerPoint(ppt)] \u21d2 \u51fa\u529b[Impress(odp),PowerPoint(ppt,pptx),PDF]" + HybsConst.CR + "xlsx,docx,pptx \u306f\uff64MS 2007\u5f62\u5f0f\u306e\u70ba\uff64LibreOffice \u306e\u307f\u5229\u7528\u3067\u304d\u307e\u3059\uff61" + HybsConst.CR;
            throw new HybsSystemException(string5);
        }
        return string4;
    }

    private static String getSuffix(String string) {
        int n;
        String string2 = "";
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }

    public static final void convert(String[] stringArray, String string, boolean bl) {
        DocConverter_OOO docConverter_OOO = new DocConverter_OOO(stringArray, bl);
        try {
            docConverter_OOO.open();
            docConverter_OOO.auto(string);
            docConverter_OOO.close();
        }
        catch (Throwable throwable) {
            docConverter_OOO.close(true);
            throw new HybsSystemException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("usage : OdsConverter [inputFile] [outputFile]");
            return;
        }
        DocConverter_OOO.convert(new String[]{stringArray[0]}, stringArray[1], false);
    }

    static {
        FILTER_MAP.put("xls_ods", "calc8");
        FILTER_MAP.put("ods_xls", "MS Excel 97");
        FILTER_MAP.put("ods_pdf", "calc_pdf_Export");
        FILTER_MAP.put("xls_pdf", "calc_pdf_Export");
        FILTER_MAP.put("doc_odt", "writer8");
        FILTER_MAP.put("odt_doc", "MS Word 97");
        FILTER_MAP.put("odt_pdf", "writer_pdf_Export");
        FILTER_MAP.put("doc_pdf", "writer_pdf_Export");
        FILTER_MAP.put("ppt_odp", "impress8");
        FILTER_MAP.put("odp_ppt", "MS PowerPoint 97");
        FILTER_MAP.put("odp_pdf", "impress_pdf_Export");
        FILTER_MAP.put("ppt_pdf", "impress_pdf_Export");
        FILTER_MAP.put("ods_xlsx", "Calc Office Open XML");
        FILTER_MAP.put("xls_xlsx", "Calc Office Open XML");
        FILTER_MAP.put("odt_docx", "MS Word 2007 XML");
        FILTER_MAP.put("doc_docx", "MS Word 2007 XML");
        FILTER_MAP.put("odp_pptx", "Impress MS PowerPoint 2007 XML");
        FILTER_MAP.put("ppt_pptx", "Impress MS PowerPoint 2007 XML");
    }

    private static final class MyPrintJobListener
    implements XPrintJobListener {
        private PrintableState status;

        private MyPrintJobListener() {
        }

        public void printJobEvent(PrintJobEvent printJobEvent) {
            this.status = printJobEvent.State;
        }

        public void disposing(EventObject eventObject) {
        }

        public boolean isError() {
            return this.status == null || this.status != PrintableState.JOB_COMPLETED && this.status != PrintableState.JOB_SPOOLED;
        }
    }
}

