<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script >
		window.onload = function(){
			dbCnt = $("#DBCNT").val();
			if(dbCnt == 0) {
				$("#XMLZIP").css('display','none');
			}
		}
	</script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0009"
	title	= "XML抜き出し"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
/>

<!-- 入力チェックを行います。 -->
<og:columnCheck
	command		= "{@command}"
	nullCheck	= "SYSTEM_ID"
/>

<og:value command="SET" key="DIR" value="{@USER.ID}/{@SYSTEM_ID}/db/resource/xml/update" />
<og:value command="SET" key="ZIP" value="{@USER.ID}/{@SYSTEM_ID}/zip" />
<og:equals val1="**" val2="{@SYSTEM_ID}" >
	<og:value command="SET" key="DIR" value="{@USER.ID}/CMN/db/resource/xml/update" />
	<og:value command="SET" key="ZIP" value="{@USER.ID}/CMN/zip" />
</og:equals>

<!-- 出力先フォルダを削除します。 -->
<og:file action="delete" useLocal="true" file1="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@DIR}" caseIf="{@DEL}" />

<!-- ZIP出力の場合、リンクを用意します。 -->
<og:equals val1="{@ZIP_FILE}" notNull="true">
	<og:link href="{@SYS.JSP}/fileDownload" target="_blank" useGamenId="false" id="XMLZIP"
				keys="file,name,useLocal" vals="{@SYS.FILE_URL}{@ZIP}/{@ZIP_FILE}.zip,{@ZIP_FILE}.zip,true" >
		<img src="{@SYS.JSP_IMG}/floppy.gif" alt="Excel Open" /> {@ZIP_FILE}.zip <og:message lbl="MSG0056" /><br />
	</og:link>
</og:equals>

<!-- 出力先フォルダのｱﾄﾞﾚｽ表示 -->
<og:text>{@SYS.REAL_PATH}{@SYS.FILE_URL}{@DIR}</og:text><br />
=============================================================================
<og:equals val1="{@TargetDB}" val2="RSC" contains="true">
	<jsp:directive.include file="result_resource.jsp" />
</og:equals>

<og:equals val1="{@TargetDB}" val2="SYS" contains="true">
	<jsp:directive.include file="result_system.jsp" />
</og:equals>

<og:equals val1="{@TargetDB}" val2="RPT" contains="true">
	<og:equals val1="{@CDKH}" isNull="true" >
	<jsp:directive.include file="result_report.jsp" />
	</og:equals>
</og:equals>

<og:equals val1="{@TargetDB}" val2="RPD" contains="true">
	<og:equals val1="{@CDKH}" isNull="true" >
		<jsp:directive.include file="result_reportData.jsp" />
	</og:equals>
</og:equals>

<br/>

<!-- ZIPファイルの作成 -->
<og:equals val1="{@ZIP_FILE}" notNull="true">
	<og:equals val1="{@DBCNT}" val2="0" notEquals="true" >
		<og:file action="zip" useLocal="true" file1="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@DIR}" file2="{@ZIP}/{@ZIP_FILE}.zip" />
		<!-- 直接ダウンロードする場合
		<og:forward page="{@SYS.JSP}/fileDownload" useRedirect="true" redirectEncode="UTF-8"
			keys="file,name,useLocal"
			vals="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@ZIP}/{@ZIP_FILE}.zip,{@ZIP_FILE}.zip,true" />
		-->
	</og:equals>
</og:equals>

<!-- 総抜出件数 (0件の場合、ZIPﾌｧｲﾙｱｲｺﾝを非表示にする JavaScript用) -->
<og:hidden name="DBCNT" value="{@DBCNT}" noForm="true" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
