<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="query" >
	<!-- link の引数を置換する -->
	<script src="{@SYS.JSP}/customGG/linkChange.js?v={@SYS.BUILD_ID}" ><!-- --></script>

	<!-- FG_RTT ﾁｪｯｸﾎﾞｯｸｽで、回転させる場合は、設定ｸﾞﾙｰﾌﾟが必須になる -->
	<script>
		var rotete = function( flag ) {
			let setGrp = document.getElementById("SET_GRP");	// 設定ｸﾞﾙｰﾌﾟ
			let fgNew  = document.getElementById("FG_NEW");		// 最新FG
			setGrp.required = flag;		// 必須設定
			if( flag ) {
				setGrp.setAttribute("class","must");
				fgNew.checked = true;	// 最新のみ設定は、trueの場合だけ。false で外さない。
			}
			else {
				setGrp.removeAttribute("class");
			}
		}
	</script>

	<!-- V* の位置がずれるが、ｲﾍﾞﾝﾄｶﾗﾑとdatalist の関係で個別対応します。 -->
	<style>
		div  + .aimaiClm { float:right; }
		span + .aimaiClm { float:right; }
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0040"
	title	= "履歴ﾃｰﾌﾞﾙ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<form method="GET" action="forward.jsp" target="RESULT"  onSubmit="timeSet();">
	<!-- 変更はここから -->
	<table summary="layout" >
		<tr>
			<og:column name="DYFROM" defaultVal="{@DATE.YMD @YMDFROM M-1}" size="8" lbl="DY_HATU" editor="YMD2"
										placeholder="{@DATE.YMDF M-1}" >	<!-- １ヶ月前 -->
				{@LBL.KARA}
				<og:column name="DYTO" defaultVal="{@DATE.YMD @YMDTO}" size="8" td="false" editor="YMD2"
										placeholder="{@DATE.YMDF}" />
			</og:column>
			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='1' で、SET_GRP をキーに登録している選択肢 -->
			<og:column name="SET_GRP"	useLblBody="true">
				<og:link gamenId="GG0030" href="index.jsp" target="CONTENTS" lbl="{@LBL.SET_GRP} (※)"
					keys="SEL_TYPE,SEL_KEY,command" vals="1,SET_GRP,NEW" />
			</og:column>

			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='2' に登録している選択肢 -->
			<og:column name="SET_KEY" aimai="V*" eventColumn="SET_GRP" useLblBody="true" >
				<!-- SET_GRP.value を選択されている SET_GRP の値を置換する。 -->
				<og:link gamenId="GG0030" href="index.jsp" target="CONTENTS" lbl="{@LBL.SET_KEY} (※)" onClick="linkChange(this);"
					keys="SEL_TYPE,SEL_KEY,command" vals="2,SET_GRP.value,NEW" />
			</og:column>
		</tr>
		<tr>
			<td colspan="2">
				<og:column name="JUDG"	 td="no"	/>
				<og:column name="FG_NEW" td="no" defaultVal="1" />		<!-- 更新ｶｳﾝﾀ(UPCNT) が一番大きいレコードのみ表示 -->
			</td>
			<og:column name="TKN_GRP"	useLblBody="true">
				<og:link gamenId="GG0030" href="index.jsp" target="CONTENTS" lbl="{@LBL.TKN_GRP} (※)"
					keys="SEL_TYPE,SEL_KEY,command" vals="0,TKN_GRP,NEW" />
			</og:column>
			<og:column name="TOKEN"		aimai="V*" />
		</tr>
		<tr>
			<og:column name="RIYU"		aimai="V*"	/>
			<td><og:column name="FG_RTT" onChange="rotete(this.checked);" td="no" /></td>	<!-- ﾃｰﾌﾞﾙ回転： -->
			<td>(<og:column name="FG_OMT" editor="CHBOX" lbl="{@LBL.TANI}{@LBL.OMIT}" td="no" />)</td>	<!-- 単位除外： -->
			<og:column name="TKN_NM"	aimai="V*" />
		</tr>
	</table>

	<og:queryButton>
		<og:select name="ORDER_BY" lbl="ORDER_BY" td="no">
			<og:option value="A.DY_HATU DESC,A.SET_GRP,A.SET_KEY,C.ROWNO,C.COLNO,A.UPCNT DESC"	lbls ="DY_HATU DESC,SET_GRP,SET_KEY,ROWNO,COLNO,UPCNT DESC"	selected="selected"  />
			<og:option value="A.DY_HATU DESC,A.SET_GRP,A.SET_KEY,A.TOKEN,A.UPCNT DESC"			lbls ="DY_HATU DESC,SET_GRP,SET_KEY,TOKEN,UPCNT DESC"		/>
			<og:option value="A.SET_GRP,A.TOKEN,A.UPCNT DESC,A.DY_HATU DESC,A.SET_KEY"			lbls ="SET_GRP,TOKEN,UPCNT DESC,DY_HATU DESC,SET_KEY"		/>
		</og:select>
	</og:queryButton>

	<!-- 拡張検索条件 -->
	<og:hideMenu>
		<table summary="layout" >
			<tr>
				<og:column name="VAL"		aimai="V*"	/>
				<og:column name="TAB_NM"	aimai="V*"	/>
			</tr>
		</table>
	</og:hideMenu>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
