<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="query" >
	<!-- link の引数を置換する -->
	<script src="{@SYS.JSP}/customGG/linkChange.js?v={@SYS.BUILD_ID}" ><!-- --></script>

	<!-- SET_KEY の datalist は、SET_GRP 変更時にクリアしないと前の値が残るが、
		 画面遷移で引数指定された時も、チェンジイベントが起こりクリアされるので、その時は変更しない -->
	<script>
		var dummy = <og:text>"{@SET_KEY}"</og:text> ;		// ﾘｸｴｽﾄ引数の初期値を設定

		function setKeyClear() {
			if( dummy ) {					// 何か書かれている場合
				dummy = "";					// 初期化する。(次回以降は、通らない)
			}
			else {							// なにも書かれていない場合
				var key = document.getElementById("SET_KEY");
				key.value="";				// SET_KEYの値をクリアする。
			}
		}
	</script>
</og:head>

<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<!-- <jsp:directive.include file="/jsp/custom/customTAB.jsp" />	-->
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0120"
	title	= "月次一覧表示"
	date	= "2021/11/19"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<form method="GET" action="forward.jsp" target="RESULT"  onSubmit="timeSet();">
	<!-- 変更はここから -->
	<table summary="layout" >
		<tr>
			<og:column name="DYFROM" defaultVal="{@DATE.YMD @YMDFROM SD}" size="8" lbl="DY_HATU" editor="YMD2"
										placeholder="{@DATE.YMDF SD}" >
				{@LBL.KARA}
				<og:column name="DYTO" defaultVal="{@DATE.YMD @YMDTO}" size="8" td="false" editor="YMD2"
										placeholder="{@DATE.YMDF}" />
			</og:column>

			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='1' で、SET_GRP をキーに登録している選択肢 -->
			<og:column name="SET_GRP" onChange="setKeyClear()" useLblBody="true" />

			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='2' に登録している選択肢 -->
			<og:column name="SET_KEY" eventColumn="SET_GRP" useLblBody="true" />
			<td><span onclick="setKeyClear()" ><og:text>({@LBL.CLEAR})</og:text></span></td>
		</tr>
	</table>

	<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
