/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.RunExec;
import org.opengion.fukurou.fileexec.XLogger;
import org.opengion.fukurou.util.StringUtil;

public final class AppliExec {
    private static final XLogger LOGGER = XLogger.getLogger(AppliExec.class.getSimpleName());
    private static final ConcurrentMap<String, AppliExec> APP_EXEC_MAP = new ConcurrentHashMap<String, AppliExec>();
    private final String[] ge72Data;
    private final RunExec runexec;

    private AppliExec(String string, String string2) {
        String string3;
        LOGGER.debug(() -> "\u2465 systemId=" + string + " , execId=" + string2);
        List<String[]> list = DBUtil.dbQuery(GE72.SELECT, string, string2);
        if (list.isEmpty()) {
            throw MsgUtil.throwException("MSG3001", "SYSTEM_ID=" + string + " , EXECID=" + string2);
        }
        this.ge72Data = list.get(0);
        String string4 = switch (string3 = this.ge72Data[GE72.RUNTYPE.NO]) {
            case "0" -> "NONE";
            case "1" -> "DBIN";
            case "3" -> "BAT";
            default -> null;
        };
        if (string4 == null) {
            throw MsgUtil.throwException("MSG3002", "RUNTYPE=" + string3 + " , systemId=" + string + " , execId=" + string2);
        }
        this.runexec = (RunExec)StringUtil.newInstance("org.opengion.fukurou.fileexec.RunExec_" + string4);
    }

    public static AppliExec newInstance(String string, String string2, String string4) {
        String string5 = string + "_" + string2;
        return APP_EXEC_MAP.computeIfAbsent(string5, string3 -> new AppliExec(string, string4));
    }

    public static void removeInstance(String string, String string2) {
        String string3 = string + "_" + string2;
        APP_EXEC_MAP.remove(string3);
    }

    public int exec(Path path) {
        return this.runexec.exec(path, this.ge72Data);
    }

    public void endExec(Path path, String string, String string2) {
        this.runexec.endExec(path, this.ge72Data, string, string2);
    }

    public static enum GE72 {
        EXECID,
        RUNTYPE,
        RUNPG,
        CLMS,
        PARAMS,
        DBID,
        TABLE_NAME,
        SHT_NOS,
        FILE_ENC,
        SKIP_CNT;

        private static final String FROM_WHERE = " from GE72 where SYSTEM_ID=? and EXECID=? and FGJ='1'";
        public static final String SELECT;
        public final int NO = this.ordinal();

        static {
            StringJoiner stringJoiner = new StringJoiner(",", "select ", FROM_WHERE);
            Arrays.stream(GE72.values()).forEachOrdered(gE72 -> stringJoiner.add(gE72.name()));
            SELECT = stringJoiner.toString();
        }
    }
}

