<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page import="org.opengion.hayabusa.common.HybsSystem" />
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page isErrorPage = "true" />

<html>
<head>
	<meta charset="UTF-8" />

	<jsp:scriptlet>
		int statusCode = pageContext.getErrorData().getStatusCode();
		if( statusCode != 401 ) {
			String jsp = HybsSystem.sys( "JSP" );
			out.println("&lt;link rel='stylesheet' href='" + jsp + "/common/default.css' /&gt;");
			out.println("&lt;link rel='stylesheet' href='" + jsp + "/custom/custom.css' /&gt;");
			// 5.7.8.1 (2014/07/11) 追加
			out.println("&lt;script src='" + jsp + "/common/jquery/jquery.js' &gt; &lt;/script&gt;");
			// 6.3.4.1 (2015/08/08) 追加
			out.println("&lt;script src='" + jsp + "/common/jquery/unblockUI.js' &gt; &lt;/script&gt;");
		}
		String title = (String)session.getAttribute( "GUI_TITLE" );
		if( title == null ) { title = "Application Error"; }
		out.println("&lt;title&gt;" + title + "&lt;/title&gt;");
	</jsp:scriptlet>

	<style>
		#time{ text-align:right; color: #ee7777; }
		#msg{ text-align:center; }
	</style>
</head>
<body>
	<jsp:scriptlet>
		String errDispLvl = HybsSystem.sys( "ERR_DISP_LEVEL" );

		// 401の場合はコードを送る必要がある
		if( statusCode == 401 ){
			response.addHeader("WWW-Authenticate", "BASIC realm=\"Web App\"");
			response.setStatus(401);
			pageContext.include( "/jsp/common/error_Auth.jsp", false );
		}
		else if( statusCode == 403 || statusCode ==404 ){
			pageContext.include( "/jsp/common/error_Forbidden.jsp", false );
		}
		else if( "1".equals( errDispLvl ) ) {
			pageContext.include( "/jsp/common/error_1.jsp", false );
		}
		else if( "2".equals( errDispLvl ) ) {
			pageContext.include( "/jsp/common/error_2.jsp", false );
		}
		else {
			pageContext.include( "/jsp/common/error_0.jsp", false );
		}
	</jsp:scriptlet>
</body>
</html>

</jsp:root>
