/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import jakarta.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.IorQueryTag;

public class IorQueryParamTag
extends CommonTagSupport {
    private static final String VERSION = "8.0.2.0 (2021/11/30)";
    private static final long serialVersionUID = 802020211130L;
    private String key;
    private String value;
    private boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.useQuotCheck(this.quotCheck);
            this.useXssCheck(this.xssCheck);
            this.value = this.getRequestParameter(this.value);
            if (this.value == null || this.value.isEmpty()) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.value = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            IorQueryTag iorQueryTag = (IorQueryTag)IorQueryParamTag.findAncestorWithClass((Tag)this, IorQueryTag.class);
            if (iorQueryTag == null) {
                String string = "<b>" + this.getTagName() + "\uff80\uff78\uff9e\u306f\u3001IorQueryTag\u306e\u5185\u5074(\u8981\u7d20)\u306b\u8a18\u8ff0\u3057\u3066\u304f\u3060\u3055\u3044\u3002</b>";
                throw new HybsSystemException(string);
            }
            iorQueryTag.addParam(this.key, this.value);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.key = null;
        this.value = null;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    }

    public void setKey(String string) {
        this.key = StringUtil.nval((String)this.getRequestParameter(string), (String)this.key);
        if (this.key == null) {
            throw new HybsSystemException("key \u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public void setValue(String string) {
        this.value = StringUtil.nval((String)this.getRequestParameter(string), (String)this.value);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("key", (Object)this.key).println("value", (Object)this.value).println("quotCheck", (Object)this.quotCheck).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

