/****************************************************************************/
/* GEA04 ( ｺｰﾄﾞ定義 )                                                       */
/*                                                                          */
/* Created : 2021/10/18 13:54:00                                            */
/****************************************************************************/

CREATE TABLE GEA04 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , CLM              VARCHAR2 (   50 )                   NOT NULL            /*  20 項目         */
 , CODE             VARCHAR2 (   30 )                   NOT NULL            /*  30 ｺｰﾄﾞ         */
 , SEQNO            NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  40 表示順       */
 , CDKH             VARCHAR2 (    1 )                                       /*  50 改廃ｺｰﾄﾞ     */
 , KBSAKU           VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /*  60 作成区分     */
 , SUBSYS           VARCHAR2 (  200 )                                       /*  70 ｻﾌﾞｼｽﾃﾑ      */
 , RELEASE_NOTES    VARCHAR2 (  120 )                                       /*  80 ﾘﾘｰｽﾉｰﾄ      */
 , RDC_CODE         VARCHAR2 (   20 )                                       /*  90 設変番号     */
 , CODEGRP          VARCHAR2 (   20 )                                       /* 100 ｺｰﾄﾞｸﾞﾙｰﾌﾟ   */
 , COMMENTS         VARCHAR2 (  500 )                                       /* 110 ｺﾒﾝﾄ         */
 , CODELVL          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 120 階層         */
 , CODE_PARAM       VARCHAR2 (  200 )                                       /* 130 ｺｰﾄﾞﾊﾟﾗﾒｰﾀ   */
 , ROLES            VARCHAR2 ( 2000 )                                       /* 140 ﾛｰﾙｽﾞ        */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET            VARCHAR2 (   14 )                                       /* 820 作成日時     */
 , PGSET            VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET           VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET           VARCHAR2 (   10 )                                       /* 850 作成者       */
 , DYUPD            VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD            VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD           VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GEA04S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA04T00 
  BEFORE INSERT ON GEA04
  FOR EACH ROW 
  BEGIN 
    SELECT GEA04S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
