/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.business;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.opengion.fukurou.business.ArrayTableModel;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.ResultSetValue;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.SystemParameter;

public abstract class AbstractBizLogic {
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int NG = 2;
    protected static final int EXCEPTION = 8;
    protected static final int ORCL_ERR = 9;
    private Connection conn;
    private Transaction tran;
    private String dbid;
    protected DBFunctionName dbName;
    private HybsLoader loader;
    private String[] keys;
    private String[] vals;
    private final Map<String, String> variableMap = new HashMap<String, String>();
    private final ConcurrentMap<String, Formatter> formatMap = new ConcurrentHashMap<String, Formatter>();
    private final ConcurrentMap<String, SystemParameter> sysParamMap = new ConcurrentHashMap<String, SystemParameter>();
    private final ErrorMessage errMsg = new ErrorMessage();
    private String bizRtn;
    private boolean debugFlag;
    private final StringBuilder debugMsg = new StringBuilder(200);
    private boolean useParamMetaData;
    private final ConcurrentMap<String, String> rtnMap = new ConcurrentHashMap<String, String>();
    private DataModel<String> table;
    int row = -1;

    protected AbstractBizLogic() {
    }

    void setTransaction(Transaction transaction) {
        this.tran = transaction;
        this.conn = this.tran.getConnection(this.dbid);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.dbid);
    }

    protected Transaction getTransaction() {
        return this.tran;
    }

    void setDbid(String string) {
        this.dbid = string;
    }

    void setLoader(HybsLoader hybsLoader) {
        if (this.loader != null) {
            String string = "\u65e2\u306b\uff78\uff97\uff7d\uff9b\uff70\uff80\uff9e\uff70\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u3059\uff61 OLD:" + this.loader + " IN :" + hybsLoader;
            throw new OgRuntimeException(string);
        }
        this.loader = hybsLoader;
    }

    void setTable(DataModel<String> dataModel) {
        if (this.table != null) {
            String string = "\u65e2\u306b\u914d\u5217\u578b\uff83\uff70\uff8c\uff9e\uff99\uff93\uff83\uff9e\uff99\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u3059\uff61 OLD:" + this.table + " IN :" + dataModel;
            throw new OgRuntimeException(string);
        }
        this.table = dataModel;
    }

    protected DataModel<String> getTable() {
        return this.table;
    }

    void setKeys(String ... stringArray) {
        if (this.keys != null) {
            String string = "\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\uff77\uff70)\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u3059\uff61" + HybsConst.CR + "   KESY   =" + Arrays.toString(this.keys) + HybsConst.CR + "   in keys=" + Arrays.toString(stringArray);
            throw new OgRuntimeException(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.keys = stringArray;
        }
    }

    void setVals(String ... stringArray) {
        if (this.vals != null) {
            String string = "\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u5024)\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u307e\u3059\uff61" + HybsConst.CR + "   VALS   =" + Arrays.toString(this.vals) + HybsConst.CR + "   in vals=" + Arrays.toString(stringArray);
            throw new OgRuntimeException(string);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.vals = stringArray;
        }
    }

    void setUserId(String string) {
        this.variableMap.put("CON.USERID", string);
    }

    void setParentPgId(String string) {
        this.variableMap.put("CON.PGPID", string);
    }

    void setDebug() {
        this.debugFlag = true;
    }

    String getDebugMsg() {
        return this.debugMsg.toString();
    }

    boolean exec() throws Throwable {
        this.dbName = DBFunctionName.getDBName(ConnectionFactory.getDBName(this.dbid));
        this.makeParamMap();
        this.init();
        return this.main();
    }

    protected abstract void init();

    protected abstract boolean main();

    int getKekka() {
        return this.errMsg.getKekka();
    }

    ErrorMessage getErrMsg() {
        return this.errMsg;
    }

    String getReturn() {
        return this.bizRtn;
    }

    boolean isRequireTable() {
        return false;
    }

    protected final boolean isDebug() {
        return this.debugFlag;
    }

    protected final void debug(String string) {
        this.debugMsg.append(string).append(HybsConst.CR);
    }

    private final String mapGet(String string) {
        if (string == null) {
            return null;
        }
        return this.variableMap.get(string.toUpperCase(Locale.JAPAN));
    }

    protected final String var(String string) {
        return this.mapGet(string);
    }

    protected final String var(String string, String string2) {
        return StringUtil.nval(this.mapGet(string), string2);
    }

    protected final int var(String string, int n) {
        return StringUtil.nval(this.mapGet(string), n);
    }

    protected final double var(String string, double d) {
        return StringUtil.nval(this.mapGet(string), d);
    }

    protected final String[] varKeys() {
        Set<String> set = this.variableMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    protected final void set(String string, String string2) {
        if (this.mapGet(string) != null) {
            String string3 = "\u3059\u3067\u306b\u767b\u9332\u6e08\u307f\u306e\uff77\uff70\u3092\u5b9a\u7fa9\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\uff61" + HybsConst.CR + "   key =" + string + HybsConst.CR + "   val =" + string2 + HybsConst.CR + "   \u5143  =" + this.mapGet(string);
            throw new OgRuntimeException(string3);
        }
        if (string != null) {
            this.variableMap.put(string.toUpperCase(Locale.JAPAN), string2);
        }
    }

    protected final void set(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    protected final void set(String string, double d) {
        this.set(string, String.valueOf(d));
    }

    protected String[][] getValues(String ... stringArray) {
        if (this.table == null) {
            String string = "\u914d\u5217\u578b\uff83\uff70\uff8c\uff9e\uff99\uff93\uff83\uff9e\uff99\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\uff64#getValues( String... )\uff92\uff7f\uff6f\uff84\uff9e\u306f\u3067\u304d\u307e\u305b\u3093\uff61" + HybsConst.CR + "   clmNms= " + Arrays.toString(stringArray) + " );" + HybsConst.CR;
            throw new OgRuntimeException(string);
        }
        return ((ArrayTableModel)this.table).getValues(stringArray);
    }

    protected final double[][] str2dblVals(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null || stringArray[0].length == 0) {
            return new double[0][0];
        }
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = StringUtil.nval(stringArray[i][j], 0.0);
            }
        }
        return dArray;
    }

    protected final String[] getNames() {
        if (this.table == null) {
            throw new OgRuntimeException("\u914d\u5217\u578b\uff83\uff70\uff8c\uff9e\uff99\uff93\uff83\uff9e\uff99\u304c\uff7e\uff6f\uff84\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\uff64#lineKeys()\uff92\uff7f\uff6f\uff84\uff9e\u306f\u3067\u304d\u307e\u305b\u3093\uff61");
        }
        return this.table.getNames();
    }

    protected final void rtn(String string) {
        this.bizRtn = string;
    }

    protected final boolean call(String string, String string2, String string3) {
        ErrMsg[] errMsgArray;
        boolean bl;
        if (this.loader == null) {
            String string4 = "#setLoader(HybsLoader)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\uff61" + HybsConst.CR + "   subLogicName =" + string + HybsConst.CR + "   key =" + string2 + HybsConst.CR + "   val =" + string3 + HybsConst.CR + "   ArrayTableModel=" + this.table;
            throw new OgRuntimeException(string4);
        }
        AbstractBizLogic abstractBizLogic = (AbstractBizLogic)this.loader.newInstance(string);
        if (abstractBizLogic.isRequireTable()) {
            String string5 = "\u3053\u306e\uff78\uff97\uff7d\u306f\uff64\u5916\u90e8\u304b\u3089\uff83\uff70\uff8c\uff9e\uff99\uff93\uff83\uff9e\uff99\u3092\uff7e\uff6f\uff84\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u305f\u3081\uff64\u5b50\uff9b\uff7c\uff9e\uff6f\uff78\u3068\u3057\u3066\u547c\u3073\u51fa\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\uff61" + HybsConst.CR + "  [\uff78\uff97\uff7d\u540d=" + abstractBizLogic.getClass().getName() + "]" + HybsConst.CR + "   subLogicName =" + string + "   key =[" + string2 + "]   val =[" + string3 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string5);
        }
        abstractBizLogic.setTransaction(this.tran);
        abstractBizLogic.setLoader(this.loader);
        abstractBizLogic.setKeys(StringUtil.csv2Array(string2));
        String[] stringArray = StringUtil.csv2Array(string3);
        this.replaceParam(stringArray);
        abstractBizLogic.setVals(stringArray);
        abstractBizLogic.setUserId(this.variableMap.get("CON.USERID"));
        abstractBizLogic.setParentPgId(this.variableMap.get("CON.PGID"));
        if (this.debugFlag) {
            abstractBizLogic.setDebug();
        }
        try {
            bl = abstractBizLogic.exec();
        }
        catch (Throwable throwable) {
            String string6 = "\u5b50\uff9b\uff7c\uff9e\uff6f\uff78\u306e\u547c\u3073\u51fa\u3057\u3067\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61" + HybsConst.CR + "   subLogicName =" + string + HybsConst.CR + "   key =[" + string2 + "]   val =[" + string3 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string6, throwable);
        }
        this.variableMap.put("RETURN", abstractBizLogic.getReturn());
        if (this.debugFlag) {
            this.debug(abstractBizLogic.getDebugMsg());
        }
        if ((errMsgArray = abstractBizLogic.getErrMsg().toArray()).length > 0) {
            ErrorMessage errorMessage = new ErrorMessage();
            for (int i = 0; i < errMsgArray.length; ++i) {
                errorMessage.addMessage(errMsgArray[i].copy(this.row));
            }
            this.errMsg.append(errorMessage);
        }
        return bl;
    }

    protected final void sql(String string) {
        DataModel<String> dataModel = this.execSQL(string, this.row, this.table);
        if (dataModel != null && dataModel.getRowCount() > 0) {
            String[] stringArray = dataModel.getNames();
            String[] stringArray2 = dataModel.getValues(0);
            for (int i = 0; i < stringArray.length; ++i) {
                this.variableMap.put(stringArray[i], stringArray2[i]);
            }
        }
    }

    protected final int seq(String string) {
        if (this.dbName == null) {
            String string2 = "#exec()\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\uff61" + HybsConst.CR + "   seqName =" + string;
            throw new OgRuntimeException(string2);
        }
        return this.dbName.getSequence(string, this.tran);
    }

    private DataModel<String> execSQL(String string, int n, DataModel<String> dataModel) {
        if (this.conn == null) {
            String string2 = "#setTransaction(Transaction)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\uff61" + HybsConst.CR + "   sql =" + string + HybsConst.CR + "   ArrayTableModel=" + dataModel;
            throw new OgRuntimeException(string2);
        }
        String string3 = this.replaceParam(string, false);
        Formatter formatter = null;
        if (dataModel != null && string3.indexOf(91) >= 0) {
            formatter = this.getFormatter(string3, dataModel);
            string3 = formatter.getQueryFormatString();
        }
        ArrayTableModel arrayTableModel = null;
        try (PreparedStatement preparedStatement = this.conn.prepareStatement(string3);){
            Object object;
            int n2;
            Wrapper wrapper;
            if (dataModel != null && formatter != null) {
                int[] nArray = formatter.getClmNos();
                if (this.useParamMetaData) {
                    wrapper = preparedStatement.getParameterMetaData();
                    for (int i = 0; i < nArray.length; ++i) {
                        n2 = wrapper.getParameterType(i + 1);
                        object = dataModel.getValue(n, nArray[i]);
                        if (object == null || ((String)object).isEmpty()) {
                            preparedStatement.setNull(i + 1, n2);
                            continue;
                        }
                        preparedStatement.setObject(i + 1, object, n2);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        preparedStatement.setObject(i + 1, dataModel.getValue(n, nArray[i]));
                    }
                }
            }
            boolean bl = preparedStatement.execute();
            wrapper = preparedStatement.getResultSet();
            try {
                if (bl) {
                    wrapper.setFetchSize(251);
                    ResultSetMetaData resultSetMetaData = wrapper.getMetaData();
                    n2 = resultSetMetaData.getColumnCount();
                    object = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        object[i] = resultSetMetaData.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
                    }
                    String[][] stringArray = DBUtil.resultToArray((ResultSet)wrapper, false);
                    arrayTableModel = new ArrayTableModel((String[])object, stringArray);
                    this.variableMap.put("SQL_ROWCOUNT", String.valueOf(arrayTableModel.getRowCount()));
                } else {
                    this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getUpdateCount()));
                }
            }
            finally {
                if (wrapper != null) {
                    wrapper.close();
                }
            }
        }
        catch (SQLException sQLException) {
            String string4 = "\u914d\u5217\u578b\uff83\uff70\uff8c\uff9e\uff99\uff93\uff83\uff9e\uff99\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff61" + HybsConst.CR + "   sql =" + string3 + HybsConst.CR + "   ArrayTableModel=" + dataModel;
            throw new OgRuntimeException(string4, sQLException);
        }
        return arrayTableModel;
    }

    protected void querySQL(String string, Consumer<String[]> consumer) {
        if (this.conn == null) {
            String string2 = "#setTransaction(Transaction)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\uff61" + HybsConst.CR + "   sql =" + string + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        String string3 = this.replaceParam(string, false);
        try (PreparedStatement preparedStatement = this.conn.prepareStatement(string3);
             ResultSet resultSet = preparedStatement.executeQuery();
             ResultSetValue resultSetValue = new ResultSetValue(resultSet);){
            while (resultSetValue.next()) {
                consumer.accept(resultSetValue.getValues());
            }
        }
        catch (SQLException sQLException) {
            String string4 = "\u691c\u7d22\u7cfbSQL \u306e\u5b9f\u884c\u306b\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff61" + HybsConst.CR + "   sql =" + string3 + HybsConst.CR;
            throw new OgRuntimeException(string4, sQLException);
        }
    }

    protected final void error(int n, String string, String ... stringArray) {
        this.error(this.row, n, string, stringArray);
    }

    protected final void error(int n, int n2, String string, String ... stringArray) {
        this.errMsg.addMessage(n, n2, string, this.replaceParam(stringArray));
    }

    protected final boolean must(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        String[] stringArray = StringUtil.csv2Array(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.mapGet(stringArray[i]);
            if (string2 != null && !string2.isEmpty()) continue;
            this.error(2, "ERR0012", "{#" + stringArray[i] + "}");
            return false;
        }
        return true;
    }

    protected final boolean exist(String string, String string2, String string3, String string4) {
        return this.exist(string, string2, string3, string4, null, null, true);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.exist(string, string2, string3, string4, string5, string6, true);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        int n;
        String string7;
        String[] stringArray;
        if (string3 == null || string3.isEmpty() || string4 == null || string4.isEmpty()) {
            String string8 = "\uff76\uff97\uff91\u53c8\u306f\uff64\u5024\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\uff61" + HybsConst.CR + "   ns =[" + string3 + "]   vs =[" + string4 + "]";
            throw new OgRuntimeException(string8);
        }
        String string9 = string3 + (String)(string5 == null || string5.isEmpty() ? "" : "," + string5);
        String[] stringArray2 = StringUtil.csv2Array(string9);
        if (stringArray2.length != (stringArray = StringUtil.csv2Array(string7 = string4 + (String)(string6 == null || string6.isEmpty() ? "" : "," + string6))).length) {
            String string10 = "\uff76\uff97\uff91\u3068\u5024\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\uff61" + HybsConst.CR + "   names = [" + string9 + "]" + HybsConst.CR + "   vals  = [" + string7 + "]";
            throw new OgRuntimeException(string10);
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("select count(*) CNT from ").append(string2);
        for (n = 0; n < stringArray2.length; ++n) {
            if (n == 0) {
                stringBuilder.append(" where ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(stringArray2[n]).append(" = ").append(stringArray[n]);
        }
        n = 0;
        DataModel<String> dataModel = this.execSQL(stringBuilder.toString(), this.row, this.table);
        if (dataModel != null && dataModel.getRowCount() >= 0) {
            n = Integer.parseInt(dataModel.getValues(0)[0]);
        }
        String string11 = this.replaceParam(string4);
        if ("true".equalsIgnoreCase(string)) {
            if (n <= 0) {
                if (bl) {
                    this.error(2, "ERR0025", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else if ("false".equalsIgnoreCase(string)) {
            if (n > 0) {
                if (bl) {
                    this.error(2, "ERR0026", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else if ("one".equalsIgnoreCase(string)) {
            if (n > 1) {
                if (bl) {
                    this.error(2, "ERR0027", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else {
            String string12 = "type\u306f\uff64true\uff64false\uff64one\u306e\u3044\u305a\u308c\u304b\u3067\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\uff61" + HybsConst.CR + "   type = [" + string + "]";
            throw new OgRuntimeException(string12);
        }
        return true;
    }

    private void makeParamMap() {
        if (this.keys != null && this.vals != null) {
            if (this.keys.length == this.vals.length) {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (this.keys[i] == null) continue;
                    this.variableMap.put(this.keys[i].toUpperCase(Locale.JAPAN), this.vals[i]);
                }
            } else {
                String string = "keys\u3068vals\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\uff61" + HybsConst.CR + "   keys   =" + Arrays.toString(this.keys) + HybsConst.CR + "   vals   =" + Arrays.toString(this.vals);
                throw new OgRuntimeException(string);
            }
        }
        String string = DateSet.getDate("yyyyMMddHHmmss");
        this.variableMap.put("CON.YMDH", string);
        this.variableMap.put("CON.YMD", string.substring(0, 8));
        this.variableMap.put("CON.HMS", string.substring(8));
        this.variableMap.put("CON.PGID", this.getClass().getSimpleName());
    }

    private String[] replaceParam(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.replaceParam(stringArray[i], true);
        }
        return stringArray;
    }

    private String replaceParam(String string) {
        return this.replaceParam(string, true);
    }

    private String replaceParam(String string, boolean bl) {
        Object object;
        if (string == null || string.isEmpty()) {
            return "";
        }
        String string2 = string;
        if (!this.variableMap.isEmpty() && string2.indexOf("{@") >= 0) {
            object = this.getSysParam(string2);
            string2 = ((SystemParameter)object).replace(this.variableMap);
        }
        if (bl && string2.indexOf(91) >= 0) {
            object = this.getFormatter(string2, this.table);
            string2 = ((Formatter)object).getFormatString(this.row);
        }
        return string2;
    }

    private Formatter getFormatter(String string, DataModel<String> dataModel) {
        String string3 = string + dataModel.toString();
        return this.formatMap.computeIfAbsent(string3, string2 -> new Formatter(dataModel, string));
    }

    private SystemParameter getSysParam(String string2) {
        String string3 = string2 == null ? "NULL" : string2;
        return this.sysParamMap.computeIfAbsent(string3, string -> new SystemParameter((String)string));
    }

    protected final void setRtnMap(String string, String string2) {
        if (string != null && string2 != null) {
            this.rtnMap.put(string, string2);
        }
    }

    protected final Map<String, String> getReturnMap() {
        return this.rtnMap;
    }
}

