/****************************************************************************/
/* GG02 ( 雛形設定ﾏｽﾀ )                                                     */
/*                                                                          */
/* Created : 2021/05/25 16:29:40                                            */
/****************************************************************************/

CREATE TABLE GG02 (
   SET_GRP  VARCHAR2 ( 100 )                    NOT NULL            /*  10 設定ｸﾞﾙｰﾌﾟ   */
 , TOKEN    VARCHAR2 ( 100 )                    NOT NULL            /*  20 ﾄｰｸﾝ         */
 , TKN_GRP  VARCHAR2 ( 200 )                                        /*  30 ﾄｰｸﾝｸﾞﾙｰﾌﾟ   */
 , TKN_NM   VARCHAR2 ( 200 )                                        /*  40 ﾄｰｸﾝ名称     */
 , TAB_NM   VARCHAR2 ( 100 )                                        /*  50 ﾀﾌﾞ名称      */
 , GRP_POS  VARCHAR2 ( 100 )                                        /*  60 ｸﾞﾙｰﾌﾟ配置   */
 , DEF_VAL  VARCHAR2 ( 200 )                                        /*  70 初期値       */
 , ROWNO    NUMBER   (   4 )        DEFAULT 1   NOT NULL            /*  80 行番号       */
 , COLNO    NUMBER   (   2 )        DEFAULT 1   NOT NULL            /*  90 列番号       */
 , ROWSPAN  NUMBER   (   2 )        DEFAULT 1   NOT NULL            /* 100 行数         */
 , COLSPAN  NUMBER   (   2 )        DEFAULT 1   NOT NULL            /* 110 列数         */
 , CDREC    VARCHAR2 (   1 )        DEFAULT '0' NOT NULL            /* 120 登録方法     */
 , CDDISP   VARCHAR2 (   1 )        DEFAULT '0' NOT NULL            /* 130 表示方法     */
 , E_MIN    VARCHAR2 (  10 )                                        /* 140 異常下限     */
 , W_MIN    VARCHAR2 (  10 )                                        /* 150 警告下限     */
 , W_MAX    VARCHAR2 (  10 )                                        /* 160 警告上限     */
 , E_MAX    VARCHAR2 (  10 )                                        /* 170 異常上限     */
 , OPT_ATTR VARCHAR2 ( 500 )                                        /* 180 ｵﾌﾟｼｮﾝ属性   */
 , UNIQ     NUMBER   (   9 )        DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ      VARCHAR2 (   1 )        DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET    VARCHAR2 (  14 )                                        /* 820 登録日時     */
 , PGSET    VARCHAR2 (  50 )                                        /* 830 作成PG       */
 , PGPSET   VARCHAR2 (  50 )                                        /* 840 作成親PG     */
 , USRSET   VARCHAR2 (  30 )                                        /* 850 作成者       */
 , DYUPD    VARCHAR2 (  14 )                                        /* 860 更新日時     */
 , PGUPD    VARCHAR2 (  50 )                                        /* 870 更新PG       */
 , PGPUPD   VARCHAR2 (  50 )                                        /* 880 更新親PG     */
 , USRUPD   VARCHAR2 (  30 )                                        /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GG02S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GG02T00 
  BEFORE INSERT ON GG02
  FOR EACH ROW 
  BEGIN 
    SELECT GG02S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
