/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;

public class HybsMahalanobis {
    private double[] dataDistance;
    private double[] average;
    private RealMatrix covariance;
    private double limen = 2.448;

    public HybsMahalanobis(double[][] dArray, boolean bl) {
        int n;
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray);
        this.covariance = new Covariance(dArray).getCovarianceMatrix();
        this.average = new double[dArray[0].length];
        for (n = 0; n < dArray[0].length; ++n) {
            this.average[n] = StatUtils.mean((double[])array2DRowRealMatrix.getColumn(n));
        }
        if (bl) {
            this.dataDistance = new double[dArray.length];
            for (n = 0; n < dArray.length; ++n) {
                this.dataDistance[n] = this.distance(this.covariance, dArray[n], this.average);
            }
        }
    }

    public HybsMahalanobis(double[][] dArray) {
        this(dArray, true);
    }

    public HybsMahalanobis(double[][] dArray, double[] dArray2) {
        this.covariance = new Array2DRowRealMatrix(dArray);
        this.average = dArray2;
    }

    public double[] getAverage() {
        return this.average;
    }

    public double[][] getCovariance() {
        return this.covariance.getData();
    }

    public double getLimen() {
        return this.limen;
    }

    public void setAverage(double[] dArray) {
        this.average = dArray;
    }

    public void setCovariance(double[][] dArray) {
        this.covariance = new Array2DRowRealMatrix(dArray);
    }

    public void setLimen(double d) {
        this.limen = d;
    }

    public double[] getDataDistance() {
        return this.dataDistance;
    }

    public double distance(double[] dArray) {
        return this.distance(this.covariance, dArray, this.average);
    }

    public boolean check(double[] dArray) {
        return this.distance(this.covariance, dArray, this.average) <= this.limen;
    }

    private double distance(RealMatrix realMatrix, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix((double[][])new double[][]{dArray3});
        RealMatrix realMatrix2 = array2DRowRealMatrix.multiply(new LUDecomposition(realMatrix).getSolver().getInverse());
        RealMatrix realMatrix3 = realMatrix2.multiply(new Array2DRowRealMatrix((double[][])new double[][]{dArray3}).transpose());
        return Math.sqrt(realMatrix3.getEntry(0, 0));
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{2.0, 10.0}, {4.0, 21.0}, {6.0, 27.0}, {8.0, 41.0}, {10.0, 50.0}};
        double[] dArray = new double[]{12.0, 50.0};
        double[] dArray2 = new double[]{12.0, 59.0};
        HybsMahalanobis hybsMahalanobis = new HybsMahalanobis(dArrayArray);
        System.out.println(Arrays.toString(hybsMahalanobis.getDataDistance()));
        System.out.println(hybsMahalanobis.check(dArray));
        System.out.println(hybsMahalanobis.check(dArray2));
    }
}

