/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.system.HybsConst;

public class JsChartDataV3 {
    public static final String DATASET = "dataset";
    public static final String AXIS = "axis";
    public static final String TICKS = "ticks";
    public static final String TIME = "time";
    public static final String TITLE = "title";
    public static final String GRID = "grid";
    public static final String OPTIONS = "options";
    public static final String PLUGINS = "plugins";
    public static final String ANNOTATIONS = "annotations";
    private static final String CR_TAB = HybsConst.CR + "\t\t";
    private final String[] AXIS_OPTS = new String[]{"ticks", "time", "title", "grid"};
    private final ConcurrentMap<String, StringBuilder> charts = new ConcurrentHashMap<String, StringBuilder>();
    private String chartColumn;
    private String yid;
    private boolean useAxis;
    private boolean useTime;
    private final StringBuilder errBuf = new StringBuilder();

    public void setChartColumn(String string) {
        this.chartColumn = string;
    }

    public String getChartColumn() {
        return this.chartColumn;
    }

    public void setId(String string) {
        this.yid = string;
        this.addAxis("id", this.yid + "Ax", false);
    }

    public void setUseAxis(boolean bl) {
        this.useAxis = bl;
    }

    public boolean isUseAxis() {
        return this.useAxis;
    }

    public void setUseTime(boolean bl) {
        this.useTime = bl;
    }

    public void addDataset(String string, String string2, boolean bl) {
        this.addBuffer(DATASET, string, string2, bl);
    }

    public void addAxis(String string, String string2, boolean bl) {
        this.addBuffer(AXIS, string, string2, bl);
    }

    public void addAxis(String string2, String string3) {
        if (string3 != null && string3.length() > 0) {
            StringBuilder stringBuilder = this.charts.computeIfAbsent(string2, string -> new StringBuilder(200));
            int n = string3.indexOf(58);
            if (n > 0 && stringBuilder.indexOf(string3.substring(0, n + 1)) >= 0) {
                this.errBuf.append("addAxis\u3067\u767b\u9332\u3055\u308c\u305f").append(string2).append("\u5c5e\u6027\u306f\u3001charts\u306b\u8a2d\u5b9a\u6e08\u307f\u3067\u3059\u3002").append(HybsConst.CR).append("val=").append(string3).append(HybsConst.CR);
            } else {
                stringBuilder.append(string3).append(',');
            }
        }
    }

    public void addTicks(String string, String string2, boolean bl) {
        this.addBuffer(TICKS, string, string2, bl);
    }

    public void addTime(String string, String string2, boolean bl) {
        this.addBuffer(TIME, string, string2, bl);
    }

    public void addPlugins(String string, String string2, boolean bl) {
        this.addBuffer(PLUGINS, string, string2, bl);
    }

    public void addAnnotations(String string, String string2, boolean bl) {
        this.addBuffer(ANNOTATIONS, string, string2, bl);
    }

    private void addBuffer(String string2, String string3, String string4, boolean bl) {
        if (string4 != null && !string4.trim().isEmpty()) {
            String string5 = string4.trim();
            StringBuilder stringBuilder = this.charts.computeIfAbsent(string2, string -> new StringBuilder(200));
            if (stringBuilder.indexOf(string3 + ":") >= 0) {
                this.errBuf.append("addBuffer\u3067\u767b\u9332\u3055\u308c\u305f").append(string2).append(':').append(string3).append("\u5c5e\u6027\u306f\u3001charts\u306b\u8a2d\u5b9a\u6e08\u307f\u3067\u3059\u3002").append(HybsConst.CR).append("key:val=").append(string3).append(':').append(string5).append(HybsConst.CR);
            } else {
                if ((DATASET.equals(string2) || AXIS.equals(string2)) && stringBuilder.length() - stringBuilder.lastIndexOf(HybsConst.CR) > 40) {
                    stringBuilder.append(CR_TAB);
                }
                if (bl || '[' == string5.charAt(0) || '{' == string5.charAt(0)) {
                    stringBuilder.append(string3).append(':').append(string5).append(',');
                } else {
                    stringBuilder.append(string3).append(":'").append(string5).append("',");
                }
            }
        }
    }

    public boolean contains(String string, String string2) {
        boolean bl = false;
        StringBuilder stringBuilder = (StringBuilder)this.charts.get(string);
        if (stringBuilder != null && stringBuilder.indexOf(string2) >= 0) {
            bl = true;
        }
        return bl;
    }

    public String getDataset(char c) {
        StringBuilder stringBuilder = this.charts.computeIfAbsent(DATASET, string -> new StringBuilder(200));
        stringBuilder.append("data:").append(this.chartColumn).append(',');
        if (this.useAxis && stringBuilder.indexOf("AxisID:") < 0 && !"y0".equals(this.yid)) {
            stringBuilder.append(c).append("AxisID:'").append(this.getAxisKey()).append("',");
        }
        return new StringBuilder(200).append("const ").append(this.getDatasetKey()).append("={").append((CharSequence)stringBuilder).append(HybsConst.CR).append("\t};").toString();
    }

    public String getDatasetKey() {
        return this.yid + "Ds";
    }

    public String getAxis() {
        StringBuilder stringBuilder = this.charts.computeIfAbsent(AXIS, string -> new StringBuilder(200));
        for (String string2 : this.AXIS_OPTS) {
            String string3;
            if (!this.useTime && TIME.equals(string2) || stringBuilder.indexOf(string3 = string2 + ":{") >= 0 || !this.charts.containsKey(string2)) continue;
            stringBuilder.append(CR_TAB).append(string3).append(this.mapGet(this.charts, string2)).append("},");
        }
        return new StringBuilder(200).append("const ").append(this.getAxisKey()).append("={").append((CharSequence)stringBuilder).append(HybsConst.CR).append("\t};").toString();
    }

    public String getAxisKey() {
        return this.yid + "Ax";
    }

    private String mapGet(ConcurrentMap<String, StringBuilder> concurrentMap, String string) {
        StringBuilder stringBuilder = (StringBuilder)concurrentMap.get(string);
        return stringBuilder == null || stringBuilder.length() == 0 ? "" : stringBuilder.toString();
    }

    public String getErrorMessage() {
        return this.errBuf.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("chartColumn=").append(this.chartColumn).append(HybsConst.CR).append("datasetKey =").append(this.getDatasetKey()).append(HybsConst.CR).append("axisKey    =").append(this.getAxisKey()).append(HybsConst.CR);
        this.charts.forEach((string, stringBuilder2) -> stringBuilder.append((String)string).append(" = ").append((CharSequence)stringBuilder2).append(HybsConst.CR));
        return stringBuilder.toString();
    }
}

