/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet.multipart;

import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.opengion.fukurou.system.Closer;
import org.opengion.hayabusa.servlet.multipart.Part;
import org.opengion.hayabusa.servlet.multipart.PartInputStream;

public class ParamPart
extends Part {
    private byte[] value;
    private final String encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParamPart(String string, ServletInputStream servletInputStream, String string2, String string3) throws IOException {
        super(string);
        this.encoding = string3;
        PartInputStream partInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            partInputStream = new PartInputStream(servletInputStream, string2);
            byteArrayOutputStream = new ByteArrayOutputStream(512);
            byte[] byArray = new byte[128];
            while ((n = partInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.value = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Closer.ioClose(partInputStream);
            Closer.ioClose(byteArrayOutputStream);
            throw throwable;
        }
        Closer.ioClose((Closeable)partInputStream);
        Closer.ioClose((Closeable)byteArrayOutputStream);
    }

    public byte[] getValue() {
        return this.value == null ? new byte[]{} : (byte[])this.value.clone();
    }

    public String getStringValue() throws UnsupportedEncodingException {
        return this.getStringValue(this.encoding);
    }

    public String getStringValue(String string) throws UnsupportedEncodingException {
        return new String(this.value, string);
    }

    @Override
    public boolean isParam() {
        return true;
    }
}

