/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import java.util.Arrays;
import org.opengion.penguin.math.statistics.HybsRegression;

public class HybsSquadraticRegression
implements HybsRegression {
    private final double[] cnst = new double[3];
    private double rsquare;

    public HybsSquadraticRegression(double[][] dArray) {
        this.train(dArray);
    }

    private void train(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d8 = dArray[i][0];
            double d9 = dArray[i][1];
            double d10 = d8 * d8;
            d2 += d8;
            d += d10;
            d3 += d8 * d9;
            d4 += d9;
            d5 += d10 * d8;
            d6 += d10 * d9;
            d7 += d10 * d10;
        }
        double d11 = d - d2 * d2 / (double)n;
        double d12 = d3 - d2 * d4 / (double)n;
        double d13 = d5 - d * d2 / (double)n;
        double d14 = d6 - d * d4 / (double)n;
        double d15 = d7 - d * d / (double)n;
        double d16 = d11 * d15 - d13 * d13;
        this.cnst[2] = (d14 * d11 - d12 * d13) / d16;
        this.cnst[1] = (d12 * d15 - d14 * d13) / d16;
        this.cnst[0] = d4 / (double)n - this.cnst[1] * d2 / (double)n - this.cnst[2] * d / (double)n;
        this.rsquare = 0.0;
    }

    @Override
    public double[] getCoefficient() {
        return Arrays.copyOf(this.cnst, this.cnst.length);
    }

    @Override
    public double getRSquare() {
        return this.rsquare;
    }

    @Override
    public double predict(double ... dArray) {
        return this.cnst[2] * dArray[0] * dArray[0] + this.cnst[1] * dArray[0] + this.cnst[0];
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.3}, {2.0, 5.1}, {3.0, 9.1}, {4.0, 16.2}};
        HybsSquadraticRegression hybsSquadraticRegression = new HybsSquadraticRegression(dArrayArray);
        double[] dArray = hybsSquadraticRegression.getCoefficient();
        System.out.println(dArray[2]);
        System.out.println(dArray[1]);
        System.out.println(dArray[0]);
        System.out.println(hybsSquadraticRegression.predict(5.0));
    }
}

