<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xpath-default-namespace="http://www.w3.org/1999/xhtml"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			  omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"	  select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"	  select="" />

  <xsl:param name="row_header" >
	 <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <TBLSYU	><xsl:value-of select="$TBLSYU"    /></TBLSYU>
	 <ADDRESS	><xsl:value-of select="$ADDRESS"   /></ADDRESS>
	 <FILENAME	><xsl:value-of select="$FILENAME"  /></FILENAME>
	 <FILEPATH	><xsl:value-of select="$FILEPATH"  /></FILEPATH>
	 <MODIFIED	><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"	   /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root">
	<xsl:apply-templates select="//og:*" />
  </xsl:template>

  <xsl:template match="og:*">
	 <ROW>
	   <xsl:copy-of select="$row_header" />
	   <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
	   <VALUELIST>
		 <xsl:for-each select="@*">
		   <xsl:value-of select="name()" />=&quot;<xsl:value-of select="." />&quot; <xsl:text />
		 </xsl:for-each>
	   </VALUELIST>
	 </ROW>
  </xsl:template>

</xsl:stylesheet>
