<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script language="JavaScript" src="../common/option/adjustField.js?v={@SYS.START_TIME}"><!-- --></script>
	<script>
		addEvent( this, "load", adjustField );
	</script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7214"
	title	= "行⇒テーブル変換"
	date	= "2012/05/17"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT   PHOTO														PHOTO		<!-- 写真		-->
			,SUORDER													SUORDER		<!-- 受注数		-->
			,KNORDER													KNORDER		<!-- 受注金額	-->
			,PN															PN			<!-- 品番		-->
			,NOORDER													NOORDER		<!-- 受注NO		-->
			,KNJISK														KNJISK		<!-- 合計原価	-->
			,NMCUST														NMCUST		<!-- 納入先名 	-->
			,SINTYOKU * 100 ||'%'										SINTYOKU 	<!-- 進捗率		-->
			,KNMIKM														KNMIKM		<!-- 見込		-->
	FROM GF45
	<og:where>
		<og:and value = "NOORDER			=		'{@NOORDER}'" 	/>		<!-- GRA01》受注NO   ＝ 画面》受注NO -->
		<og:and value = "KNORDER		&gt;=		'{@KNORDER_F}'"	/>		<!-- GRA01》受注金額 ＝ 画面》受注金額(From) -->
		<og:and value = "KNORDER		&lt;=		'{@KNORDER_T}'"	/>		<!-- GRA01》受注金額 ＝ 画面》受注金額(tO) -->
		<og:and value = "NMCUST				LIKE	'{@NMCUST}'"	/>		<!-- GRA01》受注NO   ＝ 画面》受注NO -->
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="NOORDER" />
</og:query>
<og:viewMarker command="{@command}">
	<og:columnMarker column="PHOTO"><img src="image/[PHOTO]" width="255px"/></og:columnMarker>
</og:viewMarker>
<!-- DB検索結果を表示 -->
<!-- viewFormTypeはHTMLTableにしてください。 -->
<og:view
	viewFormType = "HTMLTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
	numberType	 = "delete"
	bgColorCycle = "1"
	useHilightRow= "false"
/>
<!-- 行⇒テーブル変換 -->
<!-- colsは必須、他は任意 -->
<!-- colsWidthはcols数分の数値を設定してください。-->
<iField
	cols 		= "3"
	colsWidth	= "100,80,50"
	cellHeight	= "40"
	tables		= "2"
	tableMargin	= "0"
	tableBorder	= "5"
	useTitle	= "true"
><!-- --></iField>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
