<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="false" >
	<script src="adjustFrame.js?v={@SYS.START_TIME}"><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_tab_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9160"
	title	= "3ペインサンプル"
	date	= "2017/06/30"
	author	= "XXXXX"
	text	= ""
	version	= "001">
</og:comment>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がｾｯﾄされて遷移してきます｡ -->
<!-- 挿入処理以外､ﾃﾞｰﾀが選ばれていなければｴﾗｰ -->
<og:equals val1="{@command}" val2="INSERT" notEquals="true">
	<og:columnCheck command="{@command}" minRowCount="1" tableId="3PAIN" >
		<!-- ﾌﾚｰﾑｻｲｽﾞを調整する -->
		<script>
			adjustRightFrameWidth3();
		</script>
	</og:columnCheck>
</og:equals>

<!-- 動的にｺﾒﾝﾄを表示します｡ -->
<og:message command="{@command}" /><br />

<!-- ｷｰ -->
<og:value command="SETTBL" key="EMPNO"	tableId="3PAIN" caseKey="{@command}" caseVal="COPY|MODIFY|DELETE|VIEW" />
<og:value command="SETTBL" key="DEPTNO"	tableId="3PAIN" caseKey="{@command}" caseVal="COPY|MODIFY|DELETE|VIEW" />
<og:value command="SETTBL" key="ENAME"	tableId="3PAIN" caseKey="{@command}" caseVal="COPY|MODIFY|DELETE|VIEW" />


<!-- 【従業員ﾏｽﾀ】DB検索 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" notfoundMsg="" >
	SELECT	X.*
	FROM	(
				SELECT	 A.EMPNO
						,A.ENAME
						,A.JOB
						,A.MGR
						,A.HIREDATE
						,A.SAL
						,A.COMM
						,A.DEPTNO
				FROM	EMP A
				WHERE	A.EMPNO			=	'{@EMPNO}'
				UNION ALL
				SELECT	 NULL								EMPNO
						,NULL								ENAME
						,NULL								JOB
						,NULL								MGR
						,NULL								HIREDATE
						,NULL								SAL
						,NULL								COMM
						,NULL								DEPTNO
				FROM	DUAL
			) X
	<og:where>
		<og:and value = "ROWNUM			&lt;=	1"		/>
	</og:where>
</og:query>

<!-- 【従業員ﾏｽﾀ】ColumnEditorTag は､指定のｶﾗﾑ属性を設定しなおします｡ -->
<og:value command="SET" key="WTBL1"  value="true"						caseKey="{@command}" caseVal="COPY|MODIFY" />
<og:value command="SET" key="WTBL1"  value="false"						caseKey="{@command}" caseVal="DELETE|VIEW" />
<og:value command="SET" key="CWTBL1" value="EMPNO,ENAME,JOB,MGR,DEPTNO" caseKey="{@command}" caseVal="INSERT|COPY" />
<og:value command="SET" key="CWTBL1" value="ENAME,JOB,MGR,DEPTNO"		caseKey="{@command}" caseVal="MODIFY" />

<!-- 【部門ﾏｽﾀ】DB検索 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" notfoundMsg="" tableId="3PAIN1" >
	SELECT	X.*
	FROM	(
				SELECT	 A.DEPTNO
						,A.DNAME
						,A.LOC
				FROM	DEPT A
				WHERE	A.DEPTNO		=	'{@DEPTNO}'
				UNION ALL
				SELECT	 NULL								DEPTNO
						,NULL								DNAME
						,NULL								LOC
				FROM	DUAL
			) X
	<og:where>
		<og:and value = "ROWNUM			&lt;=	1"		/>
	</og:where>
</og:query>

<!-- 【部門ﾏｽﾀ】ColumnEditorTag は､指定のｶﾗﾑ属性を設定しなおします｡ -->
<og:value command="SET" key="WTBL2" value="true"				caseKey="{@command}" caseVal="COPY|MODIFY"	tableId="3PAIN1" />
<og:value command="SET" key="WTBL2" value="false"				caseKey="{@command}" caseVal="DELETE|VIEW"	tableId="3PAIN1" />
<og:value command="SET" key="CWTBL2" value="DEPTNO,DNAME,LOC"	caseKey="{@command}" caseVal="INSERT|COPY"	tableId="3PAIN1" />
<og:value command="SET" key="CWTBL2" value="DNAME,LOC"			caseKey="{@command}" caseVal="MODIFY"		tableId="3PAIN1" />

<!-- 【ﾎﾞｰﾅｽﾃｰﾌﾞﾙ】DB検索 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" notfoundMsg="" tableId="3PAIN2" >
	SELECT	X.*
	FROM	(
				SELECT	 A.ENAME
						,A.JOB		AS B_JOB
						,A.SAL		AS B_SAL
						,A.COMM		AS B_COMM
				FROM	BONUS A
				WHERE	A.ENAME			=	'{@ENAME}'
				UNION ALL
				SELECT	 NULL								ENAME
						,NULL								B_JOB
						,NULL								B_SAL
						,NULL								B_COMM
				FROM	DUAL
			) X
	<og:where>
		<og:and value = "ROWNUM			&lt;=	1"		/>
	</og:where>
</og:query>

<!-- 【ﾎﾞｰﾅｽﾃｰﾌﾞﾙ】ColumnEditorTag は､指定のｶﾗﾑ属性を設定しなおします｡ -->
<og:value command="SET" key="WTBL3"  value="true"			caseKey="{@command}" caseVal="COPY|MODIFY"	tableId="3PAIN2" />
<og:value command="SET" key="WTBL3"  value="false"			caseKey="{@command}" caseVal="DELETE|VIEW"	tableId="3PAIN2" />
<og:value command="SET" key="CWTBL3" value="ENAME,B_JOB"												tableId="3PAIN2" />

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
	</og:writeCheck>

	<br/>
	<table >
		<tr>
			<td class="label"><og:message lbl="EMP" /></td>
			<!-- 【従業員ﾏｽﾀ】DB検索結果を表示 -->
			<og:view
				viewFormType	= "HTMLTable"
				command			= "{@command}"
				writable		= "{@WTBL1}"
				columnWritable	= "{@CWTBL1}"
				noMessage		= "true"
				loadMarker		= "true"
				useTableSorter	= "false"
				useScrollBar	= "false"
				startNo			= "0" />
		</tr>
	</table>

	<br/>
	<table >
		<tr>
			<td class="label"><og:message lbl="DEPTNO" /></td>
			<!-- 【部門ﾏｽﾀ】DB検索結果を表示 -->
			<og:view
				viewFormType	= "HTMLTable"
				command			= "{@command}"
				writable		= "{@WTBL2}"
				columnWritable	= "{@CWTBL2}"
				noMessage		= "true"
				loadMarker		= "true"
				tableId			= "3PAIN1"
				useTableSorter	= "false"
				useScrollBar	= "false"
				startNo			= "0" />
		</tr>
	</table>

	<br/>
	<table >
		<tr>
			<td class="label"><og:message lbl="BONUS" /></td>
			<og:viewMarker command="NEW" >
				<!-- 給料 -->
				<og:columnMarker column="B_SAL" >
					<div style="background-color: #ff0000;">[B_SAL]</div>
				</og:columnMarker>
			</og:viewMarker>
			<!-- 【ﾎﾞｰﾅｽﾃｰﾌﾞﾙ】DB検索結果を表示 -->
			<og:view
				viewFormType	= "HTMLTable"
				command			= "{@command}"
				writable		= "{@WTBL3}"
				columnWritable	= "{@CWTBL3}"
				noMessage		= "true"
				loadMarker		= "true"
				tableId			= "3PAIN2"
				useTableSorter	= "false"
				useScrollBar	= "false"
				startNo			= "0" />
		</tr>
	</table>
	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</form>

<!-- ﾌﾚｰﾑｻｲｽﾞを調整する -->
<script>
	adjustRightFrameWidth2();
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
