/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.resource;

import java.util.Comparator;
import java.io.Serializable;

/**
 * 画面情報の取得の為のインターフェースです。
 *
 * ログイン時のパスワードのチェックや,国名の識別ID，ポータルページのURLなど
 * 個人情報を管理させます。
 * 特に,画面アクセス時の権限やメールの送信，各画面に画面情報を表示したり,
 * エラー時のログファイル，テンポラリディレクトリなども管理します。
 *
 * @og.group リソース管理
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class GUIInfoComparator implements Comparator<GUIInfo>,Serializable {	// 4.3.3.6 (2008/11/15) Generics警告対応
	private static final long serialVersionUID = 433620081115L ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public GUIInfoComparator() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 順序付けのために 2 つの引数を比較します。
	 *
	 * 最初の引数が 2 番目の引数より小さい場合は負の整数、
	 * 両方が等しい場合は 0、最初の引数が 2 番目の引数より大きい場合は
	 * 正の整数を返します。
	 *
	 * @og.rev 4.3.3.6 (2008/11/15) Generics警告対応
	 *
	 * @param   o1  比較対象の最初のオブジェクト
	 * @param   o2  比較対象の 2 番目のオブジェクト
	 *
	 * @return  最初の引数が 2 番目の引数より小さい場合は負の整数、両方が等しい場合は 0、最初の引数が 2 番目の引数より大きい場合は正の整数
	 */
	@Override	// Comparator
	public int compare( final GUIInfo o1, final GUIInfo o2 ) {
		final String key1 = o1.getKey();
		final String key2 = o2.getKey();
		return key1.compareTo( key2 );
	}
}
