/****************************************************************************/
/* GE18 ( 位置情報管理ﾃｰﾌﾞﾙ )                                               */
/*                                                                          */
/* Created : 2022/11/10 17:46:32                                            */
/****************************************************************************/


CREATE TABLE GE18 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , LOC_GRP      VARCHAR2 (   30 )                   NOT NULL            /*  20 位置ｸﾞﾙｰﾌﾟ   */
 , LOC_KEY      VARCHAR2 (   30 )                   NOT NULL            /*  30 固有ID       */
 , LOC_COL      NUMBER   (   22 )       DEFAULT 0   NOT NULL            /*  40 列位置       */
 , LOC_ROW      NUMBER   (   22 )       DEFAULT 0   NOT NULL            /*  50 行位置       */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  60 名称         */
 , LABEL_NAME   VARCHAR2 (   60 )                                       /*  70 表示名称     */
 , BIKO         VARCHAR2 ( 2000 )                                       /*  80 備考         */
 , ICON         VARCHAR2 (  200 )                                       /*  90 ｱｲｺﾝ         */
 , R_KEY1       VARCHAR2 (   30 )                                       /* 100 連結ｷｰ1      */
 , R_KEY2       VARCHAR2 (   30 )                                       /* 110 連結ｷｰ2      */
 , R_KEY3       VARCHAR2 (   30 )                                       /* 120 連結ｷｰ3      */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 作成日時     */
 , PGSET        VARCHAR2 (   50 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   50 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   30 )                                       /* 850 作成者       */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   50 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   50 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   30 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );



CREATE SEQUENCE GE18S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE18T00 
  BEFORE INSERT ON GE18
  FOR EACH ROW 
  BEGIN 
    SELECT GE18S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
