<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0002"
	title	= "画面"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
>
	5.5.1.5 (2012/04/12) Takahashi Masakazu **はSEQ再セットしない
	5.7.7.3 (2014/06/27) Takahashi Masakazu 削除時条件追加
</og:comment>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />

<og:transaction>
	<!-- SEQNOの再セット -->
	<og:query
		caseIf		= "{@SEL_ALL}"
		dbid		= "{@MEM.TO_DBID}"
		command		= "NEW"
		maxRowCount	= "0" >
			select	SEQNO,GUILVL,UNIQ,SYSTEM_ID,GUIKEY
			from	GEA11
			where	SYSTEM_ID IN ( '{@MEM.SYSTEM_ID}','{@U_SYSID}','{@REP.U_BASE}','{@MEM.AST}' )
			and		FGJ = '1'
			order by SEQNO,GUIKEY,ADDRESS,SYSTEM_ID DESC,KBSAKU DESC
	</og:query>
	<!-- 7.3.2.0 (2021/03/19) SYSTEM_IDが「**」の場合 SEQに 9990000 を加算する (任意) -->
	<og:tableFilter classId="SEQRESET" selectedAll="{@SEL_ALL}"
			keys="SEQ_CLM,BREAK_CLM,SYSTEM_ID,START_NO,INCREMENT"
			vals="SEQNO,GUILVL,SYSTEM_ID,{@START_NO},{@INCREMENT}" />
	<!-- where 条件は、UNIQ だけで十分だが、一応 GUIKEY も入れておく -->
	<og:tableUpdate
		dbid		= "{@MEM.TO_DBID}"
		command		= "ENTRY"
		selectedAll	= "{@SEL_ALL}"
		queryType	= "JDBCTableUpdate" >
			UPDATE GEA11 SET
				SEQNO  = [SEQNO]
			WHERE UNIQ = [UNIQ]
			AND GUIKEY = [GUIKEY]
			AND SEQNO != [SEQNO]
	</og:tableUpdate>
</og:transaction>

<!-- リソースキャッシュのクリア -->
<og:engine guiClear="true" />

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="GUI"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
