<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP02"
	title    = "データテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select
				YKNO,
				EDNO,
				KBTEXT,
				FGJ,
				TEXT_DATA,
				SYSTEM_ID
		from    GE51
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SYSTEM_ID	= '{@SYSTEM_ID}'"	/>
		<og:and value = "YKNO		= '{@YKNO}'"		/>
		<og:and value = "KBTEXT	like '{@KBTEXT}%'"		/>
		<og:and value = "FGJ		= '{@FGJ}'"			/>
		<og:and value = "EDNO {@COND1} '{@EDNO1}'"		/>
		<og:and value = "EDNO {@COND2} '{@EDNO2}'"		/>
		<og:and value = "TEXT_DATA LIKE '{@TEXT_DATA}'" />
		<og:and value = "exists(select 1 from GE50 	where GE51.SYSTEM_ID = GE51.SYSTEM_ID
										and GE51.YKNO = GE50.YKNO
										and GE50.LISTID = '{@LISTID}'
			)" />
	</og:where>
		order by SYSTEM_ID,YKNO DESC,KBTEXT DESC,EDNO
</og:query>

<og:columnEditor columns="TEXT_DATA" clazz="W100" size="200" renderer="PRE" />
<og:columnEditor columns="KBTEXT" maxlength="2" editor="TEXT" />

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />
	<og:submit  value="modifyFGJ"   lbl="FGJ"  command="MODIFY" accesskey="F" />

	<og:submit  value="verify"   lbl="Verify"  command="NEW" accesskey="V"
		keys="SYSTEM_ID,YKNO,LISTID" vals="{@SYSTEM_ID},{@YKNO},{@LISTID}"
	/>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
