/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThread;

public final class ExecThreadManager {
    private static final ConcurrentMap<String, ExecThread> EXEC_POOL = new ConcurrentHashMap<String, ExecThread>();
    private static boolean debug;

    private ExecThreadManager() {
    }

    public static void insertQueue(ExecQueue execQueue) {
        ExecThread execThread = ExecThreadManager.getExecThread(execQueue.getThreadId());
        execThread.stackQueue(execQueue);
    }

    public static void insertQueueOnNewThread(ExecQueue execQueue) {
        ExecThread execThread = new ExecThread(execQueue.getThreadId(), debug);
        execThread.start();
        execThread.stackQueue(execQueue);
        execThread.finishAfterExec();
    }

    private static ExecThread getExecThread(String string2) {
        return EXEC_POOL.compute(string2, (string, execThread) -> execThread == null || !execThread.isAlive() ? ExecThread.startExecThread(string, debug) : execThread);
    }

    public static void finishAllThreads() {
        EXEC_POOL.forEach((string, execThread) -> execThread.finish());
        System.out.println("[INFO]ALL THREADS FINISHED");
    }

    public static void finishThread(String string) {
        ExecThread execThread = (ExecThread)EXEC_POOL.remove(string);
        if (execThread != null) {
            execThread.finish();
            System.out.println("[INFO]THREAD CREATED:THREAD-ID=" + string);
        }
    }

    public static ConcurrentMap<String, String> getThreadInfo() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        EXEC_POOL.forEach((string, execThread) -> concurrentHashMap.put((String)string, execThread.toString()));
        return concurrentHashMap;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }
}

